/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.guava.common.hash;

import com.datastax.oss.driver.shaded.guava.common.annotations.Beta;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.hash.ElementTypesAreNonnullByDefault;
import com.datastax.oss.driver.shaded.guava.common.hash.HashCode;
import com.datastax.oss.driver.shaded.guava.common.hash.HashFunction;
import com.datastax.oss.driver.shaded.guava.common.hash.Hasher;
import com.datastax.oss.driver.shaded.guava.errorprone.annotations.CanIgnoreReturnValue;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingInputStream
extends FilterInputStream {
    private final Hasher hasher;

    public HashingInputStream(HashFunction hashFunction, InputStream in) {
        super(Preconditions.checkNotNull(in));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @Override
    @CanIgnoreReturnValue
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.hasher.putByte((byte)b);
        }
        return b;
    }

    @Override
    @CanIgnoreReturnValue
    public int read(byte[] bytes, int off, int len) throws IOException {
        int numOfBytesRead = this.in.read(bytes, off, len);
        if (numOfBytesRead != -1) {
            this.hasher.putBytes(bytes, off, numOfBytesRead);
        }
        return numOfBytesRead;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public HashCode hash() {
        return this.hasher.hash();
    }
}

