/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.postgres;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.server.task.json.JsonTaskAdditionalInformationSerializer;
import org.apache.james.task.Hostname;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskType;
import org.apache.james.task.eventsourcing.postgres.PostgresTaskExecutionDetailsProjectionDataDefinition$;
import org.apache.james.util.ReactorUtils;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.JSONB;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\u0007\u000f\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)a\u0007\u0001C\u0001o!)Q\t\u0001C\u0001\r\")q\f\u0001C\u0005A\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\\tI\u0003k\\:uOJ,7\u000fV1tW\u0016CXmY;uS>tG)\u001a;bS2\u001c\bK]8kK\u000e$\u0018n\u001c8E\u0003>S!a\u0004\t\u0002\u0011A|7\u000f^4sKNT!!\u0005\n\u0002\u001b\u00154XM\u001c;t_V\u00148-\u001b8h\u0015\t\u0019B#\u0001\u0003uCN\\'BA\u000b\u0017\u0003\u0015Q\u0017-\\3t\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002!A|7\u000f^4sKN,\u00050Z2vi>\u0014\bC\u0001\u0013+\u001b\u0005)#B\u0001\u0014(\u0003\u0015)H/\u001b7t\u0015\ty\u0001F\u0003\u0002*)\u0005A!-Y2lK:$7/\u0003\u0002,K\t\u0001\u0002k\\:uOJ,7/\u0012=fGV$xN]\u0001(UN|g\u000eV1tW\u0006#G-\u001b;j_:\fG.\u00138g_Jl\u0017\r^5p]N+'/[1mSj,'\u000f\u0005\u0002/i5\tqF\u0003\u00021c\u0005!!n]8o\u0015\t\u0019\"G\u0003\u00024)\u000511/\u001a:wKJL!!N\u0018\u0003O)\u001bxN\u001c+bg.\fE\rZ5uS>t\u0017\r\\%oM>\u0014X.\u0019;j_:\u001cVM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007aR4\b\u0005\u0002:\u00015\ta\u0002C\u0003#\u0007\u0001\u00071\u0005C\u0003-\u0007\u0001\u0007Q\u0006\u000b\u0002\u0004{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0007S:TWm\u0019;\u000b\u0003\t\u000bqA[1lCJ$\u0018-\u0003\u0002E\u007f\t1\u0011J\u001c6fGR\f1b]1wK\u0012+G/Y5mgR\u0011q)\u0017\t\u0004\u0011>\u000bV\"A%\u000b\u0005)[\u0015!\u00039vE2L7\u000f[3s\u0015\taU*\u0001\u0003d_J,'\"\u0001(\u0002\u000fI,\u0017m\u0019;pe&\u0011\u0001+\u0013\u0002\u0005\u001b>tw\u000e\u0005\u0002S/6\t1K\u0003\u0002U+\u0006!A.\u00198h\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W*\u0003\tY{\u0017\u000e\u001a\u0005\u00065\u0012\u0001\raW\u0001\bI\u0016$\u0018-\u001b7t!\taV,D\u0001\u0013\u0013\tq&C\u0001\u000bUCN\\W\t_3dkRLwN\u001c#fi\u0006LGn]\u0001\u000fi>Len]3siZ\u000bG.^3t)\r\t\u0007/\u001d\t\u0005E.lW.D\u0001d\u0015\t!W-A\u0004d_2dWm\u0019;\u000b\u0005\u0019<\u0017AB2p[6|gN\u0003\u0002iS\u00061qm\\8hY\u0016T\u0011A[\u0001\u0004G>l\u0017B\u00017d\u00051IU.\\;uC\ndW-T1q!\tib.\u0003\u0002p=\t\u0019\u0011I\\=\t\u000bi+\u0001\u0019A.\t\u000bI,\u0001\u0019A:\u0002?M,'/[1mSj,G-\u00113eSRLwN\\1m\u0013:4wN]7bi&|g\u000eE\u0002uofl\u0011!\u001e\u0006\u0003mV\u000bA!\u001e;jY&\u0011\u00010\u001e\u0002\t\u001fB$\u0018n\u001c8bYB\u0019!0a\u0001\u000f\u0005m|\bC\u0001?\u001f\u001b\u0005i(B\u0001@\u001b\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0001\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\tAH\u0001\u001fg\u0016\u0014\u0018.\u00197ju\u0016\fE\rZ5uS>t\u0017\r\\%oM>\u0014X.\u0019;j_:$B!!\u0004\u0002\u0010A\u0019\u0001jT:\t\u000bi3\u0001\u0019A.\u0002\u0017I,\u0017\r\u001a#fi\u0006LGn\u001d\u000b\u0005\u0003+\t9\u0002E\u0002I\u001fnCq!!\u0007\b\u0001\u0004\tY\"\u0001\u0004uCN\\\u0017\n\u001a\t\u00049\u0006u\u0011bAA\u0010%\t1A+Y:l\u0013\u0012\f1\u0002\\5ti\u0012+G/Y5mgR\u0011\u0011Q\u0005\t\u0005\u0011\u0006\u001d2,C\u0002\u0002*%\u0013AA\u00127vq\u00069B.[:u\t\u0016$\u0018-\u001b7t\u0005f\u0014UMZ8sK\u0012\u000bG/\u001a\u000b\u0005\u0003K\ty\u0003C\u0004\u00022%\u0001\r!a\r\u0002\u0015\t,gm\u001c:f\t\u0006$X\r\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI$V\u0001\u0005i&lW-\u0003\u0003\u0002>\u0005]\"aB%ogR\fg\u000e^\u0001\u0007e\u0016lwN^3\u0015\u0007\u001d\u000b\u0019\u0005C\u0003[\u0015\u0001\u00071,\u0001\fu_R\u000b7o[#yK\u000e,H/[8o\t\u0016$\u0018-\u001b7t)\rY\u0016\u0011\n\u0005\b\u0003\u0017Z\u0001\u0019AA'\u0003\u0019\u0011XmY8sIB!\u0011qJA+\u001b\t\t\tFC\u0002\u0002Ta\tAA[8pc&!\u0011qKA)\u0005\u0019\u0011VmY8sI\u0006\u0001C-Z:fe&\fG.\u001b>f\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017J\u001c4pe6\fG/[8o)\u0011\ti&!\u001c\u0011\tQ<\u0018q\f\t\u0005\u0003C\n9GD\u0002]\u0003GJ1!!\u001a\u0013\u0003Q!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0012+G/Y5mg&!\u0011\u0011NA6\u0005U\tE\rZ5uS>t\u0017\r\\%oM>\u0014X.\u0019;j_:T1!!\u001a\u0013\u0011\u001d\tY\u0005\u0004a\u0001\u0003\u001b\u0002")
public class PostgresTaskExecutionDetailsProjectionDAO {
    private final PostgresExecutor postgresExecutor;
    private final JsonTaskAdditionalInformationSerializer jsonTaskAdditionalInformationSerializer;

    public Mono<Void> saveDetails(TaskExecutionDetails details) {
        return Mono.from((Publisher)this.serializeAdditionalInformation(details).flatMap(serializedAdditionalInformation -> $this.postgresExecutor.executeVoid(dsl -> {
            ImmutableMap<Object, Object> insertValues = this.toInsertValues(details, (Optional<String>)serializedAdditionalInformation);
            InsertQuery insertStatement = dsl.insertQuery(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TABLE_NAME());
            insertStatement.addValue(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TASK_ID(), (Object)details.getTaskId().getValue());
            insertStatement.addValues(insertValues);
            insertStatement.onConflict(new Field[]{PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TASK_ID()});
            insertStatement.onDuplicateKeyUpdate(true);
            insertStatement.addValuesForUpdate(insertValues);
            return Mono.from((Publisher)insertStatement);
        })));
    }

    private ImmutableMap<Object, Object> toInsertValues(TaskExecutionDetails details, Optional<String> serializedAdditionalInformation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TYPE(), (Object)details.getType().asString());
        builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.STATUS(), (Object)details.getStatus().getValue());
        builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.SUBMITTED_DATE(), PostgresCommons.ZONED_DATE_TIME_TO_LOCAL_DATE_TIME.apply(details.getSubmittedDate()));
        builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.SUBMITTED_NODE(), (Object)details.getSubmittedNode().asString());
        details.getStartedDate().ifPresent(startedDate -> builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.STARTED_DATE(), PostgresCommons.ZONED_DATE_TIME_TO_LOCAL_DATE_TIME.apply(startedDate)));
        details.getRanNode().ifPresent(hostname -> builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.RAN_NODE(), (Object)hostname.asString()));
        details.getCompletedDate().ifPresent(completedDate -> builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.COMPLETED_DATE(), PostgresCommons.ZONED_DATE_TIME_TO_LOCAL_DATE_TIME.apply(completedDate)));
        details.getCanceledDate().ifPresent(canceledDate -> builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.CANCELED_DATE(), PostgresCommons.ZONED_DATE_TIME_TO_LOCAL_DATE_TIME.apply(canceledDate)));
        details.getCancelRequestedNode().ifPresent(hostname -> builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.CANCEL_REQUESTED_NODE(), (Object)hostname.asString()));
        details.getFailedDate().ifPresent(failedDate -> builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.FAILED_DATE(), PostgresCommons.ZONED_DATE_TIME_TO_LOCAL_DATE_TIME.apply(failedDate)));
        serializedAdditionalInformation.ifPresent(info -> builder.put(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.ADDITIONAL_INFORMATION(), (Object)JSONB.jsonb((String)info)));
        return builder.build();
    }

    private Mono<Optional<String>> serializeAdditionalInformation(TaskExecutionDetails details) {
        return Mono.fromCallable(() -> details.getAdditionalInformation().map(x$1 -> $this.jsonTaskAdditionalInformationSerializer.serialize(x$1))).cast(Optional.class).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public Mono<TaskExecutionDetails> readDetails(TaskId taskId) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.selectFrom(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TABLE_NAME()).where(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TASK_ID().eq((Object)taskId.getValue())))).map(record -> this.toTaskExecutionDetails((Record)record));
    }

    public Flux<TaskExecutionDetails> listDetails() {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TABLE_NAME()))).map(record -> this.toTaskExecutionDetails((Record)record));
    }

    public Flux<TaskExecutionDetails> listDetailsByBeforeDate(Instant beforeDate) {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TABLE_NAME()).where(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.SUBMITTED_DATE().lt(PostgresCommons.INSTANT_TO_LOCAL_DATE_TIME.apply(beforeDate))))).map(record -> this.toTaskExecutionDetails((Record)record));
    }

    public Mono<Void> remove(TaskExecutionDetails details) {
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TABLE_NAME()).where(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TASK_ID().eq((Object)details.getTaskId().getValue()))));
    }

    private TaskExecutionDetails toTaskExecutionDetails(Record record) {
        TaskId x$1 = TaskId.fromUUID((UUID)((UUID)record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TASK_ID())));
        TaskType x$22 = TaskType.of((String)((String)record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.TYPE())));
        TaskManager.Status x$32 = TaskManager.Status.fromString((String)((String)record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.STATUS())));
        ZonedDateTime x$4 = (ZonedDateTime)PostgresCommons.LOCAL_DATE_TIME_ZONED_DATE_TIME_FUNCTION.apply(record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.SUBMITTED_DATE(), LocalDateTime.class));
        Hostname x$5 = new Hostname((String)record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.SUBMITTED_NODE()));
        Optional x$6 = Optional.ofNullable(PostgresCommons.LOCAL_DATE_TIME_ZONED_DATE_TIME_FUNCTION.apply(record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.STARTED_DATE(), LocalDateTime.class)));
        Optional<Hostname> x$7 = Optional.ofNullable(record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.RAN_NODE())).map(x$2 -> new Hostname(x$2));
        Optional x$8 = Optional.ofNullable(PostgresCommons.LOCAL_DATE_TIME_ZONED_DATE_TIME_FUNCTION.apply(record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.COMPLETED_DATE(), LocalDateTime.class)));
        Optional x$9 = Optional.ofNullable(PostgresCommons.LOCAL_DATE_TIME_ZONED_DATE_TIME_FUNCTION.apply(record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.CANCELED_DATE(), LocalDateTime.class)));
        Optional<Hostname> x$10 = Optional.ofNullable(record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.CANCEL_REQUESTED_NODE())).map(x$3 -> new Hostname(x$3));
        Optional x$11 = Optional.ofNullable(PostgresCommons.LOCAL_DATE_TIME_ZONED_DATE_TIME_FUNCTION.apply(record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.FAILED_DATE(), LocalDateTime.class)));
        Function0 & Serializable x$12 = (Function0 & Serializable)() -> this.deserializeAdditionalInformation(record);
        return new TaskExecutionDetails(x$1, x$22, x$32, x$4, x$5, (Function0)x$12, x$6, x$7, x$8, x$9, x$10, x$11);
    }

    private Optional<TaskExecutionDetails.AdditionalInformation> deserializeAdditionalInformation(Record record) {
        return Optional.ofNullable(record.get(PostgresTaskExecutionDetailsProjectionDataDefinition$.MODULE$.ADDITIONAL_INFORMATION())).map(additionalInformation -> $this.jsonTaskAdditionalInformationSerializer.deserialize(additionalInformation.data()));
    }

    @Inject
    public PostgresTaskExecutionDetailsProjectionDAO(PostgresExecutor postgresExecutor, JsonTaskAdditionalInformationSerializer jsonTaskAdditionalInformationSerializer) {
        this.postgresExecutor = postgresExecutor;
        this.jsonTaskAdditionalInformationSerializer = jsonTaskAdditionalInformationSerializer;
    }
}

