/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres;

import jakarta.inject.Inject;
import java.time.Clock;
import java.util.EnumSet;
import org.apache.james.events.EventBus;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.PostgresMailboxSessionMapperFactory;
import org.apache.james.mailbox.postgres.PostgresMessageManager;
import org.apache.james.mailbox.store.MailboxManagerConfiguration;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.NoMailboxPathLocker;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class PostgresMailboxManager
extends StoreMailboxManager {
    public static final EnumSet<MailboxManager.MailboxCapabilities> MAILBOX_CAPABILITIES = EnumSet.of(MailboxManager.MailboxCapabilities.UserFlag, MailboxManager.MailboxCapabilities.Namespace, MailboxManager.MailboxCapabilities.Move, MailboxManager.MailboxCapabilities.Annotation, MailboxManager.MailboxCapabilities.ACL);
    private final PostgresMailboxSessionMapperFactory mapperFactory;

    @Inject
    public PostgresMailboxManager(PostgresMailboxSessionMapperFactory mapperFactory, SessionProvider sessionProvider, MessageParser messageParser, MessageId.Factory messageIdFactory, EventBus eventBus, StoreMailboxAnnotationManager annotationManager, StoreRightManager storeRightManager, QuotaComponents quotaComponents, MessageSearchIndex index, ThreadIdGuessingAlgorithm threadIdGuessingAlgorithm, PreDeletionHooks preDeletionHooks, Clock clock) {
        super((MailboxSessionMapperFactory)mapperFactory, sessionProvider, (MailboxPathLocker)new NoMailboxPathLocker(), messageParser, messageIdFactory, (MailboxAnnotationManager)annotationManager, eventBus, storeRightManager, quotaComponents, index, MailboxManagerConfiguration.DEFAULT, preDeletionHooks, threadIdGuessingAlgorithm, clock);
        this.mapperFactory = mapperFactory;
    }

    protected StoreMessageManager createMessageManager(Mailbox mailboxRow, MailboxSession session) {
        return new PostgresMessageManager(this.mapperFactory, this.getMessageSearchIndex(), this.getEventBus(), this.getLocker(), mailboxRow, this.getQuotaComponents().getQuotaManager(), this.getQuotaComponents().getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.configuration.getBatchSizes(), this.getStoreRightManager(), this.getThreadIdGuessingAlgorithm(), this.getClock(), this.getPreDeletionHooks());
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return MAILBOX_CAPABILITIES;
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return EnumSet.of(MailboxManager.MessageCapabilities.UniqueID);
    }
}

