/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPSDKThreadFactory
implements ThreadFactory {
    @NotNull
    private final AtomicLong threadCounter;
    private final boolean daemon;
    @NotNull
    private final String baseName;
    @Nullable
    private final ThreadGroup threadGroup;

    public LDAPSDKThreadFactory(@NotNull String baseName, boolean daemon) {
        this(baseName, daemon, null);
    }

    public LDAPSDKThreadFactory(@NotNull String baseName, boolean daemon, @Nullable ThreadGroup threadGroup) {
        this.baseName = baseName;
        this.daemon = daemon;
        this.threadGroup = threadGroup;
        this.threadCounter = new AtomicLong(1L);
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        String name = this.baseName + ' ' + this.threadCounter.getAndIncrement();
        Thread t = new Thread(this.threadGroup, r, name);
        t.setDaemon(this.daemon);
        return t;
    }
}

