/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.lib.BitsInt;
import org.apache.jena.atlas.lib.Chars;

class JsonIO {
    JsonIO() {
    }

    public static String escape(String string) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        JsonIO.escape(string, (AWriter)out);
        return out.asString();
    }

    public static void escape(String string, AWriter out) {
        JsonIO.escape(string, out, '\"');
    }

    public static void escape(String string, AWriter out, char quoteChar) {
        int len = string.length();
        block9: for (int i = 0; i < len; ++i) {
            int ch = string.charAt(i);
            if (ch == quoteChar) {
                JsonIO.esc(out, quoteChar);
                continue;
            }
            switch (ch) {
                case 92: {
                    JsonIO.esc(out, '\\');
                    continue block9;
                }
                case 47: {
                    if (i > 0 && string.charAt(i - 1) == '<') {
                        JsonIO.esc(out, '/');
                        continue block9;
                    }
                    out.print('/');
                    continue block9;
                }
                case 8: {
                    JsonIO.esc(out, 'b');
                    continue block9;
                }
                case 12: {
                    JsonIO.esc(out, 'f');
                    continue block9;
                }
                case 10: {
                    JsonIO.esc(out, 'n');
                    continue block9;
                }
                case 13: {
                    JsonIO.esc(out, 'r');
                    continue block9;
                }
                case 9: {
                    JsonIO.esc(out, 't');
                    continue block9;
                }
                default: {
                    if (ch < 32 || ch >= 127 && ch <= 159 || ch >= 8192 && ch < 8448) {
                        out.write("\\u");
                        int x = ch;
                        x = JsonIO.oneHex(out, x, 3);
                        x = JsonIO.oneHex(out, x, 2);
                        x = JsonIO.oneHex(out, x, 1);
                        x = JsonIO.oneHex(out, x, 0);
                        continue block9;
                    }
                    out.write((char)ch);
                }
            }
        }
    }

    private static void esc(AWriter out, char ch) {
        out.print('\\');
        out.print(ch);
    }

    private static int oneHex(AWriter out, int x, int i) {
        int y = BitsInt.unpack((int)x, (int)(4 * i), (int)(4 * i + 4));
        char charHex = Chars.hexDigitsUC[y];
        out.write(charHex);
        return BitsInt.clear((int)x, (int)(4 * i), (int)(4 * i + 4));
    }
}

