/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.rdf.model.Model;

class FileManagerModelCache {
    private static final int CacheSize = 500;
    boolean cacheModelLoads = false;
    Cache<String, Model> modelCache = null;

    public void resetCache() {
        if (this.modelCache != null) {
            this.modelCache.clear();
        }
    }

    public void setModelCaching(boolean state) {
        this.cacheModelLoads = state;
        if (this.cacheModelLoads && this.modelCache == null) {
            this.modelCache = CacheFactory.createCache((int)500);
        }
    }

    public boolean isCachingModels() {
        return this.cacheModelLoads;
    }

    public Model getFromCache(String filenameOrURI) {
        if (!this.isCachingModels()) {
            return null;
        }
        return (Model)this.modelCache.getIfPresent((Object)filenameOrURI);
    }

    public boolean hasCachedModel(String filenameOrURI) {
        if (!this.isCachingModels()) {
            return false;
        }
        return this.modelCache.containsKey((Object)filenameOrURI);
    }

    public void addCacheModel(String uri, Model m) {
        if (this.isCachingModels()) {
            this.modelCache.put((Object)uri, (Object)m);
        }
    }

    public void removeCacheModel(String uri) {
        if (this.isCachingModels()) {
            this.modelCache.remove((Object)uri);
        }
    }
}

