/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.core.VarExprList;

public class TransformExtendCombine
extends TransformCopy {
    @Override
    public Op transform(OpAssign opAssign, Op subOp) {
        if (subOp instanceof OpAssign) {
            OpAssign x = (OpAssign)subOp;
            VarExprList outerVarExprList = opAssign.getVarExprList();
            VarExprList innerVarExprList = new VarExprList(x.getVarExprList());
            Op r = OpAssign.assign(x.getSubOp(), innerVarExprList);
            r = OpAssign.assign(r, outerVarExprList);
            return r;
        }
        return super.transform(opAssign, subOp);
    }

    @Override
    public Op transform(OpExtend opExtend, Op subOp) {
        if (subOp instanceof OpExtend) {
            OpExtend x = (OpExtend)subOp;
            VarExprList outerVarExprList = opExtend.getVarExprList();
            VarExprList innerVarExprList = new VarExprList(x.getVarExprList());
            Op r = OpExtend.extend(x.getSubOp(), innerVarExprList);
            r = OpExtend.extend(r, outerVarExprList);
            return r;
        }
        return super.transform(opExtend, subOp);
    }
}

