/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.index.IndexFactory;
import org.apache.jena.sparql.engine.index.IndexTable;
import org.apache.jena.sparql.engine.iterator.QueryIter2;

public class QueryIterMinus
extends QueryIter2 {
    private IndexTable tableRight = null;
    private final Supplier<IndexTable> tableRightMaker = () -> IndexFactory.createIndex(commonVars, right);
    private Binding slot = null;

    public static QueryIterator create(QueryIterator left, QueryIterator right, Set<Var> commonVars, ExecutionContext qCxt) {
        if (!right.hasNext()) {
            return left;
        }
        return new QueryIterMinus(left, right, commonVars, qCxt);
    }

    private QueryIterMinus(QueryIterator left, QueryIterator right, Set<Var> commonVars, ExecutionContext qCxt) {
        super(left, right, qCxt);
    }

    protected Binding getNextSlot(Binding bindingLeft) {
        if (this.tableRight == null) {
            this.tableRight = this.tableRightMaker.get();
        }
        if (this.tableRight.containsCompatibleWithSharedDomain(bindingLeft)) {
            return null;
        }
        return bindingLeft;
    }

    @Override
    protected final void closeSubIterator() {
    }

    @Override
    protected void requestSubCancel() {
    }

    @Override
    protected final boolean hasNextBinding() {
        if (this.slot != null) {
            return true;
        }
        while (this.getLeft().hasNext()) {
            Binding bindingLeft = this.getLeft().nextBinding();
            this.slot = this.getNextSlot(bindingLeft);
            if (this.slot == null) continue;
            this.slot = bindingLeft;
            return true;
        }
        this.getLeft().close();
        return false;
    }

    @Override
    protected final Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            return null;
        }
        Binding x = this.slot;
        this.slot = null;
        return x;
    }
}

