/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.Context;

public class QueryExecApp
implements QueryExec {
    private final QueryExecMod qExecBuilder;
    private QueryExec qExecHere = null;
    private final DatasetGraph datasetHere;
    private final Query queryHere;
    private final String queryStringHere;

    public static QueryExec create(QueryExecMod qExec, DatasetGraph dataset, Query query, String queryString) {
        return new QueryExecApp(qExec, dataset, query, queryString);
    }

    private QueryExecApp(QueryExecMod qExecBuilder, DatasetGraph dataset, Query query, String queryString) {
        this.qExecBuilder = qExecBuilder;
        this.datasetHere = dataset;
        this.queryHere = query;
        this.queryStringHere = queryString;
    }

    protected QueryExec get() {
        return this.qExecHere;
    }

    public QueryExecMod getBuilder() {
        return this.qExecBuilder;
    }

    private void execution() {
        if (this.qExecHere == null) {
            this.qExecHere = this.qExecBuilder.build();
        }
    }

    @Override
    public DatasetGraph getDataset() {
        return this.datasetHere;
    }

    @Override
    public Context getContext() {
        return this.qExecBuilder.getContext();
    }

    @Override
    public Query getQuery() {
        return this.queryHere;
    }

    @Override
    public String getQueryString() {
        return this.queryStringHere;
    }

    @Override
    public RowSet select() {
        this.execution();
        return this.qExecHere.select();
    }

    @Override
    public Graph construct(Graph graph) {
        this.execution();
        return this.qExecHere.construct(graph);
    }

    @Override
    public Iterator<Triple> constructTriples() {
        this.execution();
        return this.qExecHere.constructTriples();
    }

    @Override
    public Iterator<Quad> constructQuads() {
        this.execution();
        return this.qExecHere.constructQuads();
    }

    @Override
    public DatasetGraph constructDataset(DatasetGraph dataset) {
        this.execution();
        return this.qExecHere.constructDataset(dataset);
    }

    @Override
    public Graph describe(Graph graph) {
        this.execution();
        return this.qExecHere.describe(graph);
    }

    @Override
    public Iterator<Triple> describeTriples() {
        this.execution();
        return this.qExecHere.describeTriples();
    }

    @Override
    public boolean ask() {
        this.execution();
        return this.qExecHere.ask();
    }

    @Override
    public JsonArray execJson() {
        this.execution();
        return this.qExecHere.execJson();
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        this.execution();
        return this.qExecHere.execJsonItems();
    }

    @Override
    public void abort() {
        this.execution();
        this.qExecHere.abort();
    }

    @Override
    public void close() {
        this.execution();
        this.qExecHere.close();
    }

    @Override
    public boolean isClosed() {
        if (this.qExecHere == null) {
            return false;
        }
        return this.qExecHere.isClosed();
    }

    public void timeout(long timeout, TimeUnit timeoutUnits) {
        this.qExecBuilder.timeout(timeout, timeoutUnits);
    }

    public void timeout(long timeout) {
        this.qExecBuilder.timeout(timeout, TimeUnit.MILLISECONDS);
    }

    public void timeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.qExecBuilder.initialTimeout(timeout1, timeUnit1);
        this.qExecBuilder.overallTimeout(timeout2, timeUnit2);
    }

    public void timeout(long timeout1, long timeout2) {
        this.qExecBuilder.initialTimeout(timeout1, TimeUnit.MILLISECONDS);
        this.qExecBuilder.overallTimeout(timeout2, TimeUnit.MILLISECONDS);
    }
}

