/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.text.Collator;
import java.util.Locale;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeValueVisitor;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.util.FmtUtils;

public final class NodeValueSortKey
extends NodeValue
implements Comparable<NodeValueSortKey> {
    private final String string;
    private final String collation;

    public NodeValueSortKey(String string, String collation2) {
        this.string = string;
        this.collation = collation2;
    }

    public NodeValueSortKey(String string, String collation2, Node n) {
        super(n);
        this.string = string;
        this.collation = collation2;
    }

    @Override
    public boolean isSortKey() {
        return Boolean.TRUE;
    }

    @Override
    public NodeValueSortKey getSortKey() {
        return this;
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public String asString() {
        return this.string;
    }

    public String getCollation() {
        return this.collation;
    }

    @Override
    protected Node makeNode() {
        return NodeFactory.createLiteralString((String)this.string);
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return FmtUtils.stringForNode(this.getNode());
        }
        return "'" + this.getString() + "'";
    }

    @Override
    public int compareTo(NodeValueSortKey other) {
        Objects.requireNonNull(other);
        if (this == other) {
            return 0;
        }
        String c1 = this.getCollation();
        String c2 = other.getCollation();
        if (c1 == null || c2 == null || !c1.equals(c2)) {
            return XSDFuncOp.compareString(this, other);
        }
        Locale desiredLocale = Locale.forLanguageTag(c1);
        Collator collator = Collator.getInstance(desiredLocale);
        return collator.compare(this.getString(), other.getString());
    }
}

