/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.cdt;

import java.util.List;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.function.FunctionBase2;
import org.apache.jena.sparql.function.library.cdt.CDTLiteralFunctionUtils;

public class ContainsTermFct
extends FunctionBase2 {
    @Override
    public NodeValue exec(NodeValue nv1, NodeValue nv2) {
        List<CDTValue> list = CDTLiteralFunctionUtils.checkAndGetList(nv1);
        boolean result = this.containsTerm(list, nv2);
        return NodeValue.booleanReturn(result);
    }

    protected boolean containsTerm(List<CDTValue> list, NodeValue nv) {
        for (CDTValue v : list) {
            if (!v.isNode() || !NodeFunctions.sameTerm(v.asNode(), nv.asNode())) continue;
            return true;
        }
        return false;
    }
}

