/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.update.Update;

public abstract class UpdateWithUsing
extends Update {
    private Node withIRI = null;
    private List<Node> using = new ArrayList<Node>();
    private List<Node> usingNamed = new ArrayList<Node>();
    private List<Node> usingView = Collections.unmodifiableList(this.using);
    private List<Node> usingNamedView = Collections.unmodifiableList(this.usingNamed);

    public void addUsing(Node node) {
        this.using.add(node);
    }

    public void addUsingNamed(Node node) {
        this.usingNamed.add(node);
    }

    public List<Node> getUsing() {
        return this.usingView;
    }

    public List<Node> getUsingNamed() {
        return this.usingNamedView;
    }

    public Node getWithIRI() {
        return this.withIRI;
    }

    public void setWithIRI(Node node) {
        this.withIRI = node;
    }

    protected boolean equalIso(UpdateWithUsing other, NodeIsomorphismMap isoMap) {
        if (this.withIRI == null && other.withIRI != null) {
            return false;
        }
        if (this.withIRI != null && other.withIRI == null) {
            return false;
        }
        if (this.withIRI != null && other.withIRI != null && !Iso.nodeIso(this.withIRI, other.withIRI, isoMap)) {
            return false;
        }
        if (!Iso.isomorphicNodes(this.using, other.using, isoMap)) {
            return false;
        }
        return Iso.isomorphicNodes(this.usingNamed, other.usingNamed, isoMap);
    }
}

