/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.bulk;

import java.util.List;
import org.apache.jena.query.QueryException;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.service.bulk.ChainingServiceExecutorBulk;
import org.apache.jena.sparql.service.bulk.ServiceExecutorBulk;
import org.apache.jena.sparql.service.bulk.ServiceExecutorBulkToSingle;
import org.apache.jena.sparql.service.single.ServiceExecutorOverRegistry;

public class ServiceExecutorBulkOverRegistry
implements ServiceExecutorBulk {
    protected ServiceExecutorRegistry registry;
    protected int pos;

    public ServiceExecutorBulkOverRegistry(ServiceExecutorRegistry registry) {
        this(registry, 0);
    }

    public ServiceExecutorBulkOverRegistry(ServiceExecutorRegistry registry, int pos) {
        this.registry = registry;
        this.pos = pos;
    }

    @Override
    public QueryIterator createExecution(OpService opService, QueryIterator input, ExecutionContext execCxt) {
        QueryIterator result;
        if (this.registry == null) {
            throw new QueryException("No service executor registry configured");
        }
        List<ChainingServiceExecutorBulk> factories = this.registry.getBulkChain();
        int n = factories.size();
        if (this.pos >= n) {
            ServiceExecutorOverRegistry singleExecutor = new ServiceExecutorOverRegistry(this.registry);
            ServiceExecutorBulkToSingle bridge = new ServiceExecutorBulkToSingle(singleExecutor);
            result = bridge.createExecution(opService, input, execCxt);
        } else {
            ChainingServiceExecutorBulk factory = factories.get(this.pos);
            ServiceExecutorBulkOverRegistry next = new ServiceExecutorBulkOverRegistry(this.registry, this.pos + 1);
            result = factory.createExecution(opService, input, execCxt, next);
        }
        return result;
    }
}

