/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemVisitor;

public class ItemWalker {
    static void walk(ItemVisitor visitor, Item item) {
        item.visit(new Worker(visitor));
    }

    static class Worker
    implements ItemVisitor {
        private ItemVisitor visitor;

        Worker(ItemVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visit(Item item, ItemList list) {
            for (Item subItem : list) {
                subItem.visit(this);
            }
            this.visitor.visit(item, list);
        }

        @Override
        public void visit(Item item, Node node) {
            this.visitor.visit(item, node);
        }

        @Override
        public void visit(Item item, String symbol) {
            this.visitor.visit(item, symbol);
        }

        @Override
        public void visitNil(Item item) {
        }
    }
}

