/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.atlas.lib.InternalErrorException;

public class Cardinality {
    public static final int UNSET = -3;
    public static final int UNBOUNDED = -2;
    public final String image;
    public final int min;
    public final int max;
    private static Pattern repeatRange = Pattern.compile(".(\\d+)(,(\\d+|\\*)?)?.");

    public Cardinality(String image, int min, int max) {
        this.image = image;
        this.min = min;
        this.max = max;
    }

    public static Cardinality create(String image) {
        int min = -1;
        int max = -1;
        switch (image) {
            case "*": {
                min = 0;
                max = -2;
                break;
            }
            case "?": {
                min = 0;
                max = 1;
                break;
            }
            case "+": {
                min = 1;
                max = -2;
                break;
            }
            default: {
                Matcher matcher = repeatRange.matcher(image);
                if (!matcher.matches()) {
                    throw new InternalErrorException("ShExC: Unexpected cardinality: '" + image + "'");
                }
                min = Cardinality.integerRange(matcher.group(1), -3);
                if (matcher.groupCount() != 3) {
                    throw new InternalErrorException("ShExC: Unexpected cardinality: '" + image + "'");
                }
                String comma = matcher.group(2);
                max = comma == null ? min : Cardinality.integerRange(matcher.group(3), -2);
            }
        }
        return new Cardinality(image, min, max);
    }

    private static int integerRange(String str, int dftValue) {
        if (str == null) {
            return dftValue;
        }
        if (str.equals("*")) {
            return -2;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            throw new InternalErrorException("Number format exception");
        }
    }

    static String cardStr(int min, int max) {
        if (min == -3 && max == -3) {
            return "";
        }
        if (min == 0 && max == -2) {
            return "*";
        }
        if (min == 1 && max == -2) {
            return "+";
        }
        if (min == 0 && max == 1) {
            return "?";
        }
        if (max == min) {
            return "{" + min + "}";
        }
        if (max == -2) {
            return "{" + min + ",}";
        }
        return "{" + min + "," + max + "}";
    }

    public String toString() {
        return Cardinality.cardStr(this.min, this.max);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cardinality other = (Cardinality)obj;
        return Objects.equals(this.image, other.image) && this.max == other.max && this.min == other.min;
    }
}

