/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.changes;

import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.system.Printer;
import org.apache.jena.sparql.sse.SSE;

public class RDFChangesLog
implements RDFChanges {
    private final Printer printer;

    public RDFChangesLog(Printer printer) {
        this.printer = printer;
    }

    @Override
    public void start() {
        this.print("Start", new Object[0]);
    }

    @Override
    public void finish() {
        this.print("Finish", new Object[0]);
    }

    @Override
    public void segment() {
        this.print("Z", new Object[0]);
    }

    @Override
    public void header(String field, Node value) {
        this.print("H   %s %s", field, SSE.str((Node)value));
    }

    private void print(String fmt, Object ... args) {
        this.printer.print("> " + fmt, args);
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.print("%-3s  %s %s %s %s", "Add", RDFChangesLog.strOr(g, "_"), SSE.str((Node)s), SSE.str((Node)p), SSE.str((Node)o));
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.print("%-3s  %s %s %s %s", "Del", RDFChangesLog.strOr(g, "_"), SSE.str((Node)s), SSE.str((Node)p), SSE.str((Node)o));
    }

    public static String strOr(Node n, String alt) {
        if (n == null) {
            return alt;
        }
        return SSE.str((Node)n);
    }

    @Override
    public void addPrefix(Node graph, String prefix, String uriStr) {
        this.print("AddPrefix  %s: <%s>", prefix, uriStr);
    }

    @Override
    public void deletePrefix(Node graph, String prefix) {
        this.print("DelPrefix  %s:", prefix);
    }

    @Override
    public void txnBegin() {
        this.print("Begin", new Object[0]);
    }

    @Override
    public void txnCommit() {
        this.print("Commit", new Object[0]);
    }

    @Override
    public void txnAbort() {
        this.print("Abort", new Object[0]);
    }
}

