/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBufferLib {
    public static boolean allowArray = true;

    private ByteBufferLib() {
    }

    public static void fill(ByteBuffer bb, byte v) {
        ByteBufferLib.fill(bb, bb.position(), bb.limit(), v);
    }

    public static void fill(ByteBuffer bb, int start, int finish, byte v) {
        for (int i = start; i < finish; ++i) {
            bb.put(i, v);
        }
    }

    public static String details(ByteBuffer byteBuffer) {
        return "[pos=" + byteBuffer.position() + " lim=" + byteBuffer.limit() + " cap=" + byteBuffer.capacity() + "]";
    }

    public static void print(ByteBuffer byteBuffer) {
        ByteBufferLib.print(System.out, byteBuffer);
    }

    public static void print(PrintStream out, ByteBuffer byteBuffer) {
        int i;
        byteBuffer = byteBuffer.duplicate();
        out.printf("ByteBuffer[pos=%d lim=%d cap=%d]", byteBuffer.position(), byteBuffer.limit(), byteBuffer.capacity());
        int maxBytes = 60;
        for (i = 0; i < maxBytes && i < byteBuffer.limit(); ++i) {
            if (i % 20 == 0) {
                out.println();
            }
            out.printf(" 0x%02X", byteBuffer.get(i));
        }
        if (i < byteBuffer.limit()) {
            if (i % 24 == 0) {
                out.println();
            }
            out.print(" ...");
        }
        out.println();
    }

    public static boolean sameValue(ByteBuffer bb1, ByteBuffer bb2) {
        if (bb1.capacity() != bb2.capacity()) {
            return false;
        }
        for (int i = 0; i < bb1.capacity(); ++i) {
            if (bb1.get(i) == bb2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static final ByteBuffer copyOf(ByteBuffer bb) {
        ByteBuffer bb2 = ByteBuffer.allocate(bb.limit() - bb.position());
        int x = bb.position();
        bb2.put(bb);
        bb.position(x);
        bb2.position(0);
        bb2.limit(bb2.capacity());
        return bb2;
    }

    public static final byte[] bb2array(ByteBuffer bb, int start, int finish) {
        byte[] b = new byte[finish - start];
        ByteBufferLib.bb2array(bb, start, finish, b);
        return b;
    }

    private static void bb2array(ByteBuffer bb, int start, int finish, byte[] b) {
        int j = 0;
        int i = start;
        while (i < finish) {
            b[j++] = bb.get(i++);
        }
    }

    public static final void bbcopy(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        if (src == dst) {
            return;
        }
        if (allowArray && bb.hasArray()) {
            ByteBufferLib.acopyArray(bb, src, dst, length, slotLen);
            return;
        }
        ByteBufferLib.bbcopyBulk(bb, src, dst, length, slotLen);
    }

    private static final void acopyArray(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        byte[] b = bb.array();
        int offset = bb.arrayOffset();
        int bSrc = src * slotLen;
        int bDst = dst * slotLen;
        int bLen = length * slotLen;
        System.arraycopy(b, offset + bSrc, b, offset + bDst, bLen);
    }

    private static final void bbcopyBulk(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        int bDst = dst * slotLen;
        int bSrc = src * slotLen;
        int bLen = length * slotLen;
        byte[] srcBytes = new byte[bLen];
        int pos = bb.position();
        bb.position(bSrc);
        bb.get(srcBytes, 0, bLen);
        bb.position(bDst);
        bb.put(srcBytes, 0, bLen);
        bb.position(pos);
    }

    private static final void bbcopyOLD(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        if (src == dst) {
            return;
        }
        if (allowArray && bb.hasArray()) {
            ByteBufferLib.acopyArray(bb, src, dst, length, slotLen);
            return;
        }
        if (src < dst) {
            ByteBufferLib.bbcopy1(bb, src, dst, length, slotLen);
        } else {
            ByteBufferLib.bbcopy2(bb, src, dst, length, slotLen);
        }
    }

    private static final void bbcopy1(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        int bDst = dst * slotLen;
        int bSrc = src * slotLen;
        int bLen = length * slotLen;
        for (int i = bLen - 1; i >= 0; --i) {
            bb.put(bDst + i, bb.get(bSrc + i));
        }
    }

    private static final void bbcopy2(ByteBuffer bb, int src, int dst, int length, int slotLen) {
        int bDst = dst * slotLen;
        int bSrc = src * slotLen;
        int bLen = length * slotLen;
        for (int i = 0; i < bLen; ++i) {
            bb.put(bDst + i, bb.get(bSrc + i));
        }
    }

    public static final void bbcopy(ByteBuffer bb1, int src, ByteBuffer bb2, int dst, int length, int slotLen) {
        if (bb1 == bb2) {
            throw new IllegalArgumentException("ByteBuffers are the same object");
        }
        if (allowArray && bb1.hasArray() && bb2.hasArray()) {
            ByteBufferLib.acopyArray(bb1, src, bb2, dst, length, slotLen);
            return;
        }
        int bSrc = src * slotLen;
        int bDst = dst * slotLen;
        int bLen = length * slotLen;
        byte[] srcBytes = new byte[bLen];
        int pos1 = bb1.position();
        bb1.position(bSrc);
        bb1.get(srcBytes, 0, bLen);
        bb1.position(pos1);
        int pos2 = bb2.position();
        bb2.position(bDst);
        bb2.put(srcBytes, 0, bLen);
        bb2.position(pos2);
    }

    private static final void acopyArray(ByteBuffer bb1, int src, ByteBuffer bb2, int dst, int length, int slotLen) {
        byte[] b1 = bb1.array();
        byte[] b2 = bb2.array();
        int offset1 = bb1.arrayOffset();
        int offset2 = bb2.arrayOffset();
        int bSrc = src * slotLen;
        int bDst = dst * slotLen;
        int bLen = length * slotLen;
        System.arraycopy(b1, offset1 + bSrc, b2, offset2 + bDst, bLen);
    }

    public static final void bbfill(ByteBuffer bb, int fromIdx, int toIdx, byte fillValue, int slotLen) {
        if (allowArray && bb.hasArray()) {
            ByteBufferLib.afillArray(bb, fromIdx, toIdx, fillValue, slotLen);
            return;
        }
        int bStart = fromIdx * slotLen;
        int bFinish = toIdx * slotLen;
        for (int i = bStart; i < bFinish; ++i) {
            bb.put(i, fillValue);
        }
    }

    private static final void afillArray(ByteBuffer bb, int fromIdx, int toIdx, byte fillValue, int slotLen) {
        int offset = bb.arrayOffset();
        int bStart = fromIdx * slotLen;
        int bFinish = toIdx * slotLen;
        Arrays.fill(bb.array(), bStart + offset, bFinish + offset, fillValue);
    }
}

