/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.json.JsonConfigurationFactory;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.config.yaml.YamlConfigurationFactory;

public class LogCtlLog4j2 {
    public static String log4j2setup = Log4j2Setup.log4j2setup();

    public static void resetLogging(String configString) {
        LogCtlLog4j2.reconfigureLog4j2fromString(configString, SyntaxHint.PROPERTIES);
    }

    public static void resetLogging(InputStream inputStream, String resourceName) {
        LogCtlLog4j2.resetLogging(inputStream, LogCtlLog4j2.determineSyntax(resourceName));
    }

    public static void resetLogging(InputStream inputStream, SyntaxHint syntaxHint) {
        Configuration config = LogCtlLog4j2.log4j2Configuration(inputStream, syntaxHint);
        LogCtlLog4j2.reconfigureLog4j(config);
    }

    static String getLoggerlevel(String logger) {
        Level level = LogManager.getLogger((String)logger).getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    static void setLoggerlevel(String logger, String levelName) {
        Level level = Level.ALL;
        if (levelName == null) {
            level = null;
        } else if (levelName.equalsIgnoreCase("info")) {
            level = Level.INFO;
        } else if (levelName.equalsIgnoreCase("debug")) {
            level = Level.DEBUG;
        } else if (levelName.equalsIgnoreCase("warn") || levelName.equalsIgnoreCase("warning")) {
            level = Level.WARN;
        } else if (levelName.equalsIgnoreCase("error") || levelName.equalsIgnoreCase("severe")) {
            level = Level.ERROR;
        } else if (levelName.equalsIgnoreCase("fatal")) {
            level = Level.FATAL;
        } else if (levelName.equalsIgnoreCase("OFF")) {
            level = Level.OFF;
        }
        LogCtlLog4j2.setLoggerlevel(logger, level);
    }

    static void setLoggerlevel(String logger, Level level) {
        try {
            if (!logger.equals("")) {
                Configurator.setLevel((String)logger, (Level)level);
            } else {
                Configurator.setRootLevel((Level)level);
            }
        }
        catch (NoClassDefFoundError ex) {
            Log.warnOnce(LogCtlLog4j2.class, "Log4j2 Configurator not found", LogCtl.class);
        }
    }

    static void setLoggerlevel(Logger logger, Level level) {
        try {
            Configurator.setLevel((Logger)logger, (Level)level);
        }
        catch (NoClassDefFoundError ex) {
            Log.warnOnce(LogCtlLog4j2.class, "Log4j2 Configurator not found", LogCtl.class);
        }
    }

    public static void reconfigureLog4j2fromFile(String filename) {
        Configurator.initialize(null, (String)filename);
    }

    public static void reconfigureLog4j2fromFile(String filename, SyntaxHint syntaxHint) {
        Configuration config = LogCtlLog4j2.log4j2ConfigurationFromFile(filename, syntaxHint);
        LogCtlLog4j2.reconfigureLog4j(config);
    }

    public static void reconfigureLog4j2fromString(String configString, SyntaxHint syntaxHint) {
        Configuration config = LogCtlLog4j2.log4j2ConfigurationFromString(configString, syntaxHint);
        LogCtlLog4j2.reconfigureLog4j(config);
    }

    private static void reconfigureLog4j(Configuration config) {
        config.initialize();
        Configurator.reconfigure((Configuration)config);
    }

    private static Configuration log4j2ConfigurationFromFile(String filename, SyntaxHint syntaxHint) {
        URI uri = Path.of(filename, new String[0]).toUri();
        ConfigurationSource source = ConfigurationSource.fromUri((URI)uri);
        return LogCtlLog4j2.createLog4jConfiguration(source, syntaxHint);
    }

    private static Configuration log4j2ConfigurationFromString(String text, SyntaxHint syntaxHint) {
        Configuration configuration;
        ByteArrayInputStream input = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
        try {
            configuration = LogCtlLog4j2.log4j2Configuration(input, syntaxHint);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        ((InputStream)input).close();
        return configuration;
    }

    private static Configuration log4j2Configuration(InputStream inputStream, SyntaxHint syntaxHint) {
        try {
            ConfigurationSource source = new ConfigurationSource(inputStream);
            return LogCtlLog4j2.createLog4jConfiguration(source, syntaxHint);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Configuration createLog4jConfiguration(ConfigurationSource source, SyntaxHint syntaxHint) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(syntaxHint);
        ConfigurationFactory factory = switch (syntaxHint) {
            case SyntaxHint.PROPERTIES -> new PropertiesConfigurationFactory();
            case SyntaxHint.XML -> new XmlConfigurationFactory();
            case SyntaxHint.JSON -> new JsonConfigurationFactory();
            case SyntaxHint.YAML -> new YamlConfigurationFactory();
            default -> ConfigurationFactory.getInstance();
        };
        Configuration configuration = factory.getConfiguration(null, source);
        if (configuration == null) {
            throw new UnsupportedOperationException("Can't create a configuration for '" + String.valueOf(source) + "' using '" + String.valueOf((Object)syntaxHint) + "'");
        }
        return configuration;
    }

    private static SyntaxHint determineSyntax(String filename) {
        String ext = FilenameUtils.getExtension((String)filename);
        if (ext == null) {
            throw new IllegalArgumentException("No file extension");
        }
        SyntaxHint hint = SyntaxHint.fromName(ext);
        if (hint == null) {
            throw new IllegalArgumentException("File extension not recognized: '" + ext + "'");
        }
        return hint;
    }

    public static enum SyntaxHint {
        PROPERTIES("properties"),
        XML("xml"),
        JSON("json"),
        YAML("yaml");

        private String syntaxName;

        private SyntaxHint(String syntaxName) {
            this.syntaxName = syntaxName;
        }

        static SyntaxHint fromName(String name) {
            for (SyntaxHint hint : SyntaxHint.values()) {
                if (!hint.syntaxName.equalsIgnoreCase(name)) continue;
                return hint;
            }
            return null;
        }
    }

    static class Log4j2Setup {
        Log4j2Setup() {
        }

        private static String log4j2setup() {
            return String.join((CharSequence)Log4j2Setup.log4jSetupSep(), Log4j2Setup.log4j2setupBase(), Log4j2Setup.log4j2setupJenaLib(), Log4j2Setup.log4j2setupFuseki());
        }

        private static String log4jSetupSep() {
            return "\n";
        }

        private static String log4j2setupBase() {
            return "## Log4j2 properties syntax.\nstatus = error\nname = JenaLoggingDft\n\n# filters = threshold\n# filter.threshold.type = ThresholdFilter\n# filter.threshold.level = ALL\n\nappender.console.type = Console\nappender.console.name = OUT\nappender.console.target = SYSTEM_OUT\nappender.console.layout.type = PatternLayout\nappender.console.layout.pattern = %d{HH:mm:ss} %-5p %-15c{1} :: %m%n\n# appender.console.layout.pattern = [%d{yyyy-MM-dd HH:mm:ss}] %-5p %-15c{1} :: %m%n\n\nrootLogger.level                  = INFO\nrootLogger.appenderRef.stdout.ref = OUT\n";
        }

        private static String log4j2setupJenaLib() {
            return "logger.jena.name  = org.apache.jena\nlogger.jena.level = INFO\n\nlogger.arq-exec.name  = org.apache.jena.arq.exec\nlogger.arq-exec.level = INFO\n\nlogger.riot.name  = org.apache.jena.riot\nlogger.riot.level = INFO\n";
        }

        private static String log4j2setupFuseki() {
            return "# Fuseki. In case this logging setup gets install for embedded Fuseki.\n\nlogger.fuseki.name  = org.apache.jena.fuseki\nlogger.fuseki.level = INFO\nlogger.fuseki-fuseki.name  = org.apache.jena.fuseki.Fuseki\nlogger.fuseki-fuseki.level = INFO\n\nlogger.fuseki-server.name  = org.apache.jena.fuseki.Server\nlogger.fuseki-server.level = INFO\n\nlogger.fuseki-config.name  = org.apache.jena.fuseki.Config\nlogger.fuseki-config.level = INFO\n\nlogger.fuseki-admin.name  = org.apache.jena.fuseki.Admin\nlogger.fuseki-admin.level = INFO\n\nlogger.jetty.name  = org.eclipse.jetty\nlogger.jetty.level = WARN\n\nlogger.shiro.name = org.apache.shiro\nlogger.shiro.level = WARN\n\n# This goes out in NCSA format\nappender.plain.type = Console\nappender.plain.name = PLAIN\nappender.plain.layout.type = PatternLayout\nappender.plain.layout.pattern = %m%n\n\nlogger.fuseki-request.name                   = org.apache.jena.fuseki.Request\nlogger.fuseki-request.additivity             = false\nlogger.fuseki-request.level                  = OFF\nlogger.fuseki-request.appenderRef.plain.ref  = PLAIN\n";
        }
    }
}

