/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.rfc3986.ErrorHandler;

public class ErrorHandlerBase
implements ErrorHandler {
    private final Consumer<String> onError;
    private final Consumer<String> onWarning;

    public static ErrorHandler create(Consumer<String> onError, Consumer<String> onWarning) {
        return new ErrorHandlerBase(ErrorHandlerBase.handler(onError), ErrorHandlerBase.handler(onWarning));
    }

    private ErrorHandlerBase(Consumer<String> onError, Consumer<String> onWarning) {
        this.onError = Objects.requireNonNull(onError, "onError");
        this.onWarning = Objects.requireNonNull(onWarning, "onWarning");
    }

    private static Consumer<String> handler(Consumer<String> eventHandler) {
        return eventHandler == null ? x -> {} : eventHandler;
    }

    @Override
    public void warning(String message) {
        this.onWarning.accept(message);
    }

    @Override
    public void error(String message) {
        this.onError.accept(message);
    }
}

