/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986.cmd;

import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.cmd.CmdBase;

public class CmdResolve {
    public static void main(String ... args) {
        if (args.length != 2) {
            System.err.println("Requires two arguments - base IRI and IRI to resolve.");
            System.exit(1);
        }
        String baseStr = CmdBase.fixup(args[0]);
        String relStr = CmdBase.fixup(args[1]);
        IRI3986 base = CmdBase.createOrExit(baseStr, "Bad base");
        IRI3986 rel = CmdBase.createOrExit(relStr, "Bad relative IRI");
        if (!base.isAbsolute()) {
            System.err.println("Base should be an absolute IRI: '" + String.valueOf(base) + "'");
        }
        IRI3986 result = base.resolve(rel);
        System.out.println("Base:     " + String.valueOf(base));
        System.out.println("IRI:      " + String.valueOf(rel));
        System.out.println();
        System.out.println("Resolved: " + String.valueOf(result));
        System.out.println();
        CmdBase.print(result);
    }
}

