/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ContainerRemove;
import org.apache.jena.util.iterator.NiceIterator;

public class ContNodeIteratorImpl
extends NiceIterator<RDFNode>
implements NodeIterator {
    protected Statement recent = null;
    protected final Container cont;
    protected int size;
    protected int index = 0;
    protected int numDeleted = 0;
    protected final List<Integer> moved = new ArrayList<Integer>();
    protected final Iterator<Statement> iterator;

    public ContNodeIteratorImpl(Iterator<Statement> iterator, Container cont) {
        this.iterator = iterator;
        this.cont = cont;
        this.size = cont.size();
    }

    @Override
    public RDFNode next() throws NoSuchElementException {
        this.recent = this.iterator.next();
        ++this.index;
        return this.recent.getObject();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public RDFNode nextNode() throws NoSuchElementException {
        return this.next();
    }

    @Override
    public void remove() throws NoSuchElementException {
        if (this.recent == null) {
            throw new NoSuchElementException();
        }
        this.iterator.remove();
        if (this.index > this.size - this.numDeleted) {
            ((ContainerRemove)((Object)this.cont)).remove(this.moved.get(this.size - this.index), this.recent.getObject());
        } else {
            this.cont.remove(this.recent);
            this.moved.add(this.index);
        }
        this.recent = null;
        ++this.numDeleted;
    }
}

