/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.builtins;

import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;
import org.apache.jena.util.iterator.ClosableIterator;

public class CountLiteralValues
extends BaseBuiltin {
    @Override
    public String getName() {
        return "countLiteralValues";
    }

    @Override
    public int getArgLength() {
        return 3;
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        ArrayList<Node> values = new ArrayList<Node>();
        Node a0 = this.getArg(0, args, context);
        Node a1 = this.getArg(1, args, context);
        ClosableIterator<Triple> ni = context.find(a0, a1, null);
        while (ni.hasNext()) {
            Node v = ((Triple)ni.next()).getObject();
            if (!v.isLiteral()) continue;
            boolean gotit = false;
            for (Node value : values) {
                if (!v.sameValueAs(value)) continue;
                gotit = true;
                break;
            }
            if (gotit) continue;
            values.add(v);
        }
        return context.getEnv().bind(args[2], Util.makeIntNode(values.size()));
    }
}

