/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.ValueSpace;

public abstract class ValueRangeConstraint
extends ConstraintTerm {
    protected final NodeValue nodeValue;
    private final Node constraintComponent;

    protected ValueRangeConstraint(Node value, Node constraintComponent) {
        this.nodeValue = NodeValue.makeNode((Node)value);
        this.constraintComponent = constraintComponent;
    }

    public NodeValue getNodeValue() {
        return this.nodeValue;
    }

    @Override
    public final ReportItem validate(ValidationContext vCxt, Node n) {
        NodeValue nv = NodeValue.makeNode((Node)n);
        ValueSpace vs = NodeValue.classifyValueOp((NodeValue)this.nodeValue, (NodeValue)nv);
        try {
            int r = NodeValue.compare((NodeValue)this.nodeValue, (NodeValue)nv);
            if (r == 2) {
                return new ReportItem(this.toString() + " indeterminant to " + String.valueOf(n), n);
            }
            boolean b = this.test(r);
            if (b) {
                return null;
            }
            return new ReportItem(this.getErrorMessage(n), n);
        }
        catch (ExprNotComparableException ex) {
            return new ReportItem(this.toString() + " can't compare to " + String.valueOf(n), n);
        }
    }

    protected abstract String getErrorMessage(Node var1);

    protected abstract boolean test(int var1);

    protected abstract String getName();

    @Override
    public final Node getComponent() {
        return this.constraintComponent;
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compact(out, nodeFmt, this.getName(), this.nodeValue.asNode());
    }

    public String toString() {
        return this.getName() + "[" + String.valueOf(this.nodeValue) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.constraintComponent, this.nodeValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ValueRangeConstraint other = (ValueRangeConstraint)obj;
        return Objects.equals(this.constraintComponent, other.constraintComponent) && Objects.equals(this.nodeValue, other.nodeValue);
    }
}

