/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.ShapeVisitor;
import org.apache.jena.shacl.validation.Severity;
import org.apache.jena.sparql.path.Path;

public class PropertyShape
extends Shape {
    private final Path path;

    public PropertyShape(Graph shapeGraph, Node shapeNode, boolean isDeactivated, Severity severity, Collection<Node> messages, Collection<Target> targets, Path path, List<Constraint> constraints, List<PropertyShape> propertyShapes) {
        super(shapeGraph, shapeNode, isDeactivated, severity, messages, targets, constraints, propertyShapes);
        this.path = Objects.requireNonNull(path, "path");
    }

    @Override
    public void visit(ShapeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isPropertyShape() {
        return true;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void printHeader(IndentedWriter out, NodeFormatter nodeFmt) {
        out.print("PropertyShape ");
        ShaclPaths.write(out, this.path, nodeFmt);
    }

    @Override
    public String toString() {
        String x = "PropertyShape[" + String.valueOf(this.getShapeNode()) + " -> " + String.valueOf(this.path) + "]";
        if (this.deactivated()) {
            x = x + " deactivated";
        }
        return x;
    }
}

