/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.validation.Severity;
import org.apache.jena.shacl.vocabulary.SHACLM;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.vocabulary.RDF;

public class ReportEntry {
    private Node focusNode = null;
    private Path resultPath;
    private Node value;
    private Node source;
    private Constraint constraint;
    private Node sourceConstraint;
    private Node sourceConstraintComponent;
    private Severity severity;
    private final Collection<Node> messages = new ArrayList<Node>(5);
    private Node detail;
    private Triple triple;

    private ReportEntry() {
    }

    public static ReportEntry create() {
        return new ReportEntry();
    }

    public Node focusNode() {
        return this.focusNode;
    }

    public ReportEntry focusNode(Node node) {
        this.focusNode = node;
        return this;
    }

    public Path resultPath() {
        return this.resultPath;
    }

    public ReportEntry resultPath(Path path) {
        this.resultPath = path;
        return this;
    }

    public Triple triple() {
        return this.triple;
    }

    public ReportEntry triple(Triple triple) {
        this.triple = triple;
        return this;
    }

    public Node value() {
        return this.value;
    }

    public ReportEntry value(Node node) {
        this.value = node;
        return this;
    }

    public Node source() {
        return this.source;
    }

    public ReportEntry source(Node node) {
        this.source = node;
        return this;
    }

    public Constraint constraint() {
        return this.constraint;
    }

    public ReportEntry constraint(Constraint constraint) {
        this.constraint = constraint;
        if (constraint != null) {
            this.sourceConstraintComponent(constraint.getComponent());
        }
        return this;
    }

    public Node sourceConstraint() {
        return this.sourceConstraint;
    }

    public ReportEntry sourceConstraint(Node sourceConstraint) {
        this.sourceConstraint = sourceConstraint;
        return this;
    }

    public Node sourceConstraintComponent() {
        return this.sourceConstraintComponent;
    }

    public ReportEntry sourceConstraintComponent(Node component) {
        this.sourceConstraintComponent = component;
        return this;
    }

    public Node detail() {
        return this.detail;
    }

    public ReportEntry detail(Node n) {
        this.detail = n;
        return this;
    }

    public ReportEntry message(Node node) {
        if (node != null) {
            this.messages.add(node);
        }
        return this;
    }

    public ReportEntry message(String msg) {
        if (msg != null) {
            this.messages.add(NodeFactory.createLiteralString((String)msg));
        }
        return this;
    }

    public String message() {
        if (this.messages() != null && this.messages().size() == 1) {
            return ReportEntry.asString((Node)CollectionUtils.oneElt(this.messages));
        }
        StringJoiner sj = new StringJoiner(",", "[", "]");
        for (Node n : this.messages) {
            sj.add(NodeFmtLib.displayStr((Node)n));
        }
        return sj.toString();
    }

    public Collection<Node> messages() {
        return this.messages;
    }

    private static String asString(Node message) {
        if (message == null) {
            return null;
        }
        if (message.isLiteral()) {
            return message.getLiteralLexicalForm();
        }
        if (message.isURI()) {
            return message.getURI();
        }
        throw new ShaclException("Not a literal or URI: " + String.valueOf(message));
    }

    public Severity severity() {
        return this.severity;
    }

    public ReportEntry severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public ReportEntry severity(Node severity) {
        this.severity = severity == null ? null : Severity.create(severity);
        return this;
    }

    public void generate(Model model, Resource report) {
        Resource entry = model.createResource();
        entry.addProperty(RDF.type, (RDFNode)SHACLM.ValidationResult);
        report.addProperty(SHACLM.result, (RDFNode)entry);
        Function<Node, RDFNode> rdfNode = gn -> ModelUtils.convertGraphNodeToRDFNode((Node)gn, (Model)entry.getModel());
        Function<String, RDFNode> str = s -> entry.getModel().createLiteral(s);
        Objects.requireNonNull(this.focusNode, "focus node");
        Objects.requireNonNull(this.severity, "severity");
        Objects.requireNonNull(this.sourceConstraintComponent, "sourceConstraintComponent");
        entry.addProperty(SHACLM.focusNode, rdfNode.apply(this.focusNode));
        entry.addProperty(SHACLM.resultSeverity, rdfNode.apply(this.severity.level()));
        entry.addProperty(SHACLM.sourceConstraintComponent, rdfNode.apply(this.sourceConstraintComponent));
        for (Node msg : this.messages) {
            entry.addProperty(SHACLM.resultMessage, rdfNode.apply(msg));
        }
        if (this.sourceConstraint != null) {
            entry.addProperty(SHACLM.sourceConstraint, rdfNode.apply(this.sourceConstraint));
        }
        if (this.source != null) {
            entry.addProperty(SHACLM.sourceShape, rdfNode.apply(this.source));
        }
        if (this.resultPath != null) {
            Node pn = ShaclPaths.pathToRDF(arg_0 -> ((Graph)model.getGraph()).add(arg_0), this.resultPath);
            entry.addProperty(SHACLM.resultPath, rdfNode.apply(pn));
        }
        if (this.value != null) {
            entry.addProperty(SHACLM.value, rdfNode.apply(this.value));
        }
    }

    public String toString() {
        if (this.resultPath() != null) {
            return String.format("Node=%s\n  Path=%s\n  %s", ShLib.displayStr(this.focusNode()), this.resultPath(), this.message());
        }
        return String.format("Node=%s\n  %s", ShLib.displayStr(this.focusNode()), this.message());
    }

    public int hashCode() {
        return Objects.hash(this.constraint, this.detail, this.focusNode, this.messages, this.resultPath, this.severity, this.source, this.sourceConstraint, this.sourceConstraintComponent, this.triple, this.value);
    }

    public boolean same(ReportEntry obj) {
        return Objects.equals(this.focusNode, obj.focusNode) && this.severity == obj.severity && Objects.equals(this.sourceConstraintComponent, obj.sourceConstraintComponent) && Objects.equals(this.resultPath, obj.resultPath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportEntry)) {
            return false;
        }
        ReportEntry other = (ReportEntry)obj;
        return Objects.equals(this.constraint, other.constraint) && Objects.equals(this.detail, other.detail) && Objects.equals(this.focusNode, other.focusNode) && Objects.equals(this.messages, other.messages) && Objects.equals(this.resultPath, other.resultPath) && this.severity == other.severity && Objects.equals(this.source, other.source) && Objects.equals(this.sourceConstraint, other.sourceConstraint) && Objects.equals(this.sourceConstraintComponent, other.sourceConstraintComponent) && Objects.equals(this.triple, other.triple) && Objects.equals(this.value, other.value);
    }
}

