/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.langtag.cmd;

import org.apache.jena.langtag.LangTag;
import org.apache.jena.langtag.LangTagException;
import org.apache.jena.langtag.SysLangTag;

public class CmdLangTag {
    public static void main(String[] args) {
        String languageTag;
        if (args.length != 1) {
            System.err.println("Requires one argument.");
            System.exit(1);
        }
        if ((languageTag = args[0]).isEmpty()) {
            System.err.println("Empty string for language tag");
            System.exit(1);
        }
        if (languageTag.isBlank()) {
            System.err.println("Blank string for language tag");
            System.exit(1);
        }
        if (languageTag.contains(" ") || languageTag.contains("\t") || languageTag.contains("\n") || languageTag.contains("\r")) {
            System.err.println("Language tag contains white space");
            System.exit(1);
        }
        if (languageTag.contains("--")) {
            System.err.println("Illgeal language tag. String contains '--'");
            System.exit(1);
        }
        try {
            System.out.printf("%-16s %s\n", "Input:", languageTag);
            LangTag langTag = SysLangTag.create(languageTag);
            CmdLangTag.print("Formatted:", langTag.str(), true);
            CmdLangTag.print("Language:", langTag.getLanguage(), true);
            CmdLangTag.print("Script:", langTag.getScript(), true);
            CmdLangTag.print("Region:", langTag.getRegion(), true);
            CmdLangTag.print("Variant:", langTag.getVariant(), false);
            CmdLangTag.print("Extension:", langTag.getExtension(), false);
            CmdLangTag.print("Private Use:", langTag.getPrivateUse(), false);
        }
        catch (LangTagException ex) {
            System.out.println("Bad language tag");
            System.out.printf("%s\n", ex.getMessage());
            System.exit(1);
        }
    }

    private static void print(String label, String value, boolean always) {
        if (value == null) {
            if (!always) {
                return;
            }
            value = "-";
        }
        System.out.printf("  %-14s %s\n", label, value);
    }
}

