/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarList;
import org.apache.juneau.svl.VarResolverSession;

public class VarResolver {
    public static final VarResolver DEFAULT = (VarResolver)VarResolver.create().defaultVars().build();
    final Var[] vars;
    private final Map<String, Var> varMap;
    final BeanStore beanStore;

    public static Builder create() {
        return new Builder();
    }

    private static Var toVar(BeanStore bs, Object o) {
        if (o instanceof Class) {
            Class o2 = (Class)o;
            return bs.createBean(Var.class).type(o2).run();
        }
        return (Var)o;
    }

    protected VarResolver(Builder builder) {
        this.vars = (Var[])builder.vars.stream().map(x -> VarResolver.toVar(builder.beanStore(), x)).toArray(Var[]::new);
        ConcurrentSkipListMap<String, Var> m = new ConcurrentSkipListMap<String, Var>();
        for (Var v : this.vars) {
            m.put(v.getName(), v);
        }
        this.varMap = CollectionUtils.u(m);
        this.beanStore = BeanStore.of(builder.beanStore());
    }

    public <T> VarResolver addBean(Class<T> c, T value) {
        this.beanStore.addBean(c, value);
        return this;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public VarResolverSession createSession() {
        return new VarResolverSession(this, null);
    }

    public VarResolverSession createSession(BeanStore beanStore) {
        return new VarResolverSession(this, beanStore);
    }

    public String resolve(String s) {
        return this.createSession(null).resolve(s);
    }

    public void resolveTo(String s, Writer w) throws IOException {
        this.createSession(null).resolveTo(s, w);
    }

    protected Map<String, Var> getVarMap() {
        return this.varMap;
    }

    protected Var[] getVars() {
        return Arrays.copyOf(this.vars, this.vars.length);
    }

    public static class Builder
    extends BeanBuilder<VarResolver> {
        final VarList vars;

        protected Builder() {
            super(VarResolver.class, BeanStore.create().build());
            this.vars = VarList.create();
        }

        protected Builder(VarResolver copyFrom) {
            super(copyFrom.getClass(), copyFrom.beanStore);
            this.vars = VarList.of(copyFrom.vars);
        }

        public <T> Builder bean(Class<T> c, T value) {
            this.beanStore().addBean(c, value);
            return this;
        }

        public Builder defaultVars() {
            this.vars.addDefault();
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @SafeVarargs
        public final Builder vars(Class<? extends Var> ... values) {
            this.vars.append(values);
            return this;
        }

        public Builder vars(Var ... values) {
            this.vars.append(values);
            return this;
        }

        public Builder vars(VarList values) {
            this.vars.append(values);
            return this;
        }

        @Override
        protected VarResolver buildDefault() {
            return new VarResolver(this);
        }
    }
}

