/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.juneau.commons.function.OptionalSupplier;
import org.apache.juneau.commons.function.ResettableSupplier;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.settings.FunctionalSource;
import org.apache.juneau.commons.settings.MapStore;
import org.apache.juneau.commons.settings.SettingSource;
import org.apache.juneau.commons.settings.SettingStore;
import org.apache.juneau.commons.settings.StringSetting;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class Settings {
    public static final SettingSource SYSTEM_PROPERTY_SOURCE = FunctionalSource.of(System::getProperty);
    private static final Set<String> FROM_STRING_METHOD_NAMES = new LinkedHashSet<String>(Arrays.asList("fromString", "parse", "forName", "valueOf"));
    public static final SettingSource SYSTEM_ENV_SOURCE = FunctionalSource.of(System::getenv);
    private static final String DISABLE_GLOBAL_PROP = "juneau.settings.disableGlobal";
    private static final String MSG_globalDisabled = "Global settings not enabled";
    private static final String MSG_localDisabled = "Local settings not enabled";
    private static final Settings INSTANCE = new Builder().globalStore(Settings.initProperty("juneau.settings.disableGlobal").map(Boolean::valueOf).orElse(false) != false ? () -> null : () -> new MapStore()).setSources(SYSTEM_ENV_SOURCE, SYSTEM_PROPERTY_SOURCE).build();
    private final ResettableSupplier<SettingStore> globalStore;
    private final ThreadLocal<SettingStore> localStore;
    private final List<SettingSource> sources;
    private final Map<Class<?>, Function<String, ?>> toTypeFunctions;

    private static final Optional<String> initProperty(String property) {
        Optional<String> v = SYSTEM_PROPERTY_SOURCE.get(property);
        if (v != null) {
            return v;
        }
        v = SYSTEM_ENV_SOURCE.get(property.replace('.', '_').toUpperCase());
        if (v != null) {
            return v;
        }
        return Utils.opte();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Settings get() {
        return INSTANCE;
    }

    private Settings(Builder builder) {
        this.globalStore = Utils.memr(builder.globalStoreSupplier);
        this.localStore = ThreadLocal.withInitial(builder.localStoreSupplier);
        this.sources = new CopyOnWriteArrayList<SettingSource>(builder.sources);
        this.toTypeFunctions = new ConcurrentHashMap(builder.customTypeFunctions);
    }

    public StringSetting get(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        return new StringSetting(this, () -> {
            Optional<String> v = this.localStore.get().get(name);
            if (v != null) {
                return v.orElse(null);
            }
            v = this.globalStore.get().get(name);
            if (v != null) {
                return v.orElse(null);
            }
            for (int i = this.sources.size() - 1; i >= 0; --i) {
                SettingSource source = this.sources.get(i);
                Optional<String> result = source.get(name);
                if (result == null) continue;
                return result.orElse(null);
            }
            return null;
        });
    }

    public <T> T get(String name, T def) {
        AssertionUtils.assertArgNotNull("def", def);
        return this.get(name).asType(def.getClass()).orElse(def);
    }

    public Settings setGlobal(String name, String value) {
        AssertionUtils.assertArgNotNull("name", name);
        ((SettingStore)this.globalStore.orElseThrow(() -> ThrowableUtils.illegalState(MSG_globalDisabled, new Object[0]))).set(name, value);
        return this;
    }

    public void unsetGlobal(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        ((SettingStore)this.globalStore.orElseThrow(() -> ThrowableUtils.illegalState(MSG_globalDisabled, new Object[0]))).unset(name);
    }

    public Settings setLocal(String name, String value) {
        AssertionUtils.assertArgNotNull("name", name);
        AssertionUtils.assertState(Utils.nn(this.localStore.get()), MSG_localDisabled, new Object[0]);
        this.localStore.get().set(name, value);
        return this;
    }

    public void unsetLocal(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        AssertionUtils.assertState(Utils.nn(this.localStore.get()), MSG_localDisabled, new Object[0]);
        this.localStore.get().unset(name);
    }

    public Settings clearLocal() {
        AssertionUtils.assertState(Utils.nn(this.localStore.get()), MSG_localDisabled, new Object[0]);
        this.localStore.get().clear();
        return this;
    }

    public Settings clearGlobal() {
        ((SettingStore)this.globalStore.orElseThrow(() -> ThrowableUtils.illegalState(MSG_globalDisabled, new Object[0]))).clear();
        return this;
    }

    protected <T> T toType(String s, Class<T> c) {
        AssertionUtils.assertArgNotNull("s", s);
        AssertionUtils.assertArgNotNull("c", c);
        Function f = this.toTypeFunctions.get(c);
        if (f == null) {
            if (c == String.class) {
                return (T)s;
            }
            if (c.isEnum()) {
                return Enum.valueOf(c, s);
            }
            ClassInfoTyped<T> ci = ReflectionUtils.info(c);
            f = ci.getDeclaredMethod(x -> x.isStatic() && x.hasParameterTypes(String.class) && x.hasReturnType(c) && FROM_STRING_METHOD_NAMES.contains(x.getName())).map(x -> s2 -> x.invoke(null, s2)).orElse(null);
            if (f == null) {
                f = ci.getPublicConstructor(x -> x.hasParameterTypes(String.class)).map(x -> s2 -> x.newInstance(s2)).orElse(null);
            }
            if (f != null) {
                this.toTypeFunctions.putIfAbsent(c, f);
            }
        }
        if (f == null) {
            throw ThrowableUtils.rex("Invalid env type: {0}", c);
        }
        return (T)f.apply((String)s);
    }

    public static class Builder {
        private Supplier<SettingStore> globalStoreSupplier = () -> new MapStore();
        private Supplier<SettingStore> localStoreSupplier = () -> new MapStore();
        private final List<SettingSource> sources = new ArrayList<SettingSource>();
        private final Map<Class<?>, Function<String, ?>> customTypeFunctions = new IdentityHashMap();

        public Builder globalStore(OptionalSupplier<SettingStore> supplier) {
            this.globalStoreSupplier = AssertionUtils.assertArgNotNull("supplier", supplier);
            return this;
        }

        public Builder localStore(OptionalSupplier<SettingStore> supplier) {
            this.localStoreSupplier = AssertionUtils.assertArgNotNull("supplier", supplier);
            return this;
        }

        @SafeVarargs
        public final Builder setSources(SettingSource ... sources) {
            AssertionUtils.assertArgNoNulls("sources", sources);
            this.sources.clear();
            for (SettingSource source : sources) {
                this.sources.add(source);
            }
            return this;
        }

        public Builder addSource(SettingSource source) {
            AssertionUtils.assertArgNotNull("source", source);
            this.sources.add(source);
            return this;
        }

        public Builder addSource(FunctionalSource source) {
            return this.addSource((SettingSource)source);
        }

        public <T> Builder addTypeFunction(Class<T> type, Function<String, T> function) {
            AssertionUtils.assertArgNotNull("type", type);
            AssertionUtils.assertArgNotNull("function", function);
            this.customTypeFunctions.put(type, function);
            return this;
        }

        public Settings build() {
            return new Settings(this);
        }
    }
}

