/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class IntegerValue
extends Value<Integer> {
    public static IntegerValue create() {
        return IntegerValue.of(0);
    }

    public static IntegerValue of(Integer value) {
        return new IntegerValue(value);
    }

    public IntegerValue() {
        super(0);
    }

    public IntegerValue(Integer value) {
        super(value == null ? 0 : value);
    }

    public IntegerValue add(Integer x) {
        this.set((Integer)this.get() + (x == null ? 0 : x));
        return this;
    }

    public Integer addAndGet(Integer x) {
        this.set((Integer)this.get() + (x == null ? 0 : x));
        return (Integer)this.get();
    }

    public IntegerValue decrement() {
        this.set((Integer)this.get() - 1);
        return this;
    }

    public Integer decrementAndGet() {
        this.set((Integer)this.get() - 1);
        return (Integer)this.get();
    }

    public Integer getAndIncrement() {
        Integer v = (Integer)this.get();
        int result = v == null ? 0 : v;
        this.set(result + 1);
        return result;
    }

    public IntegerValue increment() {
        this.set((Integer)this.get() + 1);
        return this;
    }

    public Integer incrementAndGet() {
        this.set((Integer)this.get() + 1);
        return (Integer)this.get();
    }

    @Override
    public boolean is(Integer value) {
        return Utils.eq((Integer)this.get(), value);
    }

    public boolean isAny(Integer ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        Integer current = (Integer)this.get();
        for (Integer value : values) {
            if (!Utils.eq(current, value)) continue;
            return true;
        }
        return false;
    }
}

