/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.stats;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.stats.MethodExecStats;
import org.apache.juneau.rest.stats.ThrownStore;

public class MethodExecStore {
    private final ThrownStore thrownStore;
    private final BeanStore beanStore;
    private final Class<? extends MethodExecStats> statsImplClass;
    private final ConcurrentHashMap<Method, MethodExecStats> db = new ConcurrentHashMap();

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected MethodExecStore(Builder builder) {
        this.beanStore = builder.beanStore();
        this.thrownStore = Utils.nn(builder.thrownStore) ? builder.thrownStore : this.beanStore.getBean(ThrownStore.class).orElseGet(ThrownStore::new);
        this.statsImplClass = builder.statsImplClass;
    }

    public String getReport() {
        StringBuilder sb = new StringBuilder().append(" Method                         Runs      Running   Errors   Avg          Total     \n").append("------------------------------ --------- --------- -------- ------------ -----------\n");
        this.getStatsByTotalTime().stream().sorted(Comparator.comparingDouble(MethodExecStats::getTotalTime).reversed()).forEach(x -> sb.append(String.format("%30s %9d %9d %9d %10dms %10dms\n", x.getMethod(), x.getRuns(), x.getRunning(), x.getErrors(), x.getAvgTime(), x.getTotalTime())));
        return sb.toString();
    }

    public Collection<MethodExecStats> getStats() {
        return this.db.values();
    }

    public MethodExecStats getStats(Method m) {
        MethodExecStats stats = this.db.get(m);
        if (stats == null) {
            stats = (MethodExecStats)((MethodExecStats.Builder)MethodExecStats.create(this.beanStore).type((Class)this.statsImplClass)).method(m).thrownStore((ThrownStore)ThrownStore.create(this.beanStore).parent(this.thrownStore).build()).build();
            this.db.putIfAbsent(m, stats);
            stats = this.db.get(m);
        }
        return stats;
    }

    public List<MethodExecStats> getStatsByTotalTime() {
        return this.getStats().stream().sorted(Comparator.comparingLong(MethodExecStats::getTotalTime).reversed()).collect(Collectors.toList());
    }

    public ThrownStore getThrownStore() {
        return this.thrownStore;
    }

    public static class Builder
    extends BeanBuilder<MethodExecStore> {
        ThrownStore thrownStore;
        Class<? extends MethodExecStats> statsImplClass;

        protected Builder(BeanStore beanStore) {
            super(MethodExecStore.class, beanStore);
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder statsImplClass(Class<? extends MethodExecStats> value) {
            this.statsImplClass = value;
            return this;
        }

        public Builder thrownStore(ThrownStore value) {
            this.thrownStore = value;
            return this;
        }

        public Builder thrownStoreOnce(ThrownStore value) {
            if (this.thrownStore == null) {
                this.thrownStore = value;
            }
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected MethodExecStore buildDefault() {
            return new MethodExecStore(this);
        }
    }
}

