/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiServiceRef;
import com.cloudera.api.swagger.model.ReplicationStrategy;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Replication arguments for HDFS.")
public class ApiHdfsReplicationArguments {
    @SerializedName(value="sourceService")
    private ApiServiceRef sourceService = null;
    @SerializedName(value="sourcePath")
    private String sourcePath = null;
    @SerializedName(value="destinationPath")
    private String destinationPath = null;
    @SerializedName(value="mapreduceServiceName")
    private String mapreduceServiceName = null;
    @SerializedName(value="schedulerPoolName")
    private String schedulerPoolName = null;
    @SerializedName(value="userName")
    private String userName = null;
    @SerializedName(value="sourceUser")
    private String sourceUser = null;
    @SerializedName(value="numMaps")
    private BigDecimal numMaps = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="bandwidthPerMap")
    private BigDecimal bandwidthPerMap = null;
    @SerializedName(value="abortOnError")
    private Boolean abortOnError = null;
    @SerializedName(value="removeMissingFiles")
    private Boolean removeMissingFiles = null;
    @SerializedName(value="preserveReplicationCount")
    private Boolean preserveReplicationCount = null;
    @SerializedName(value="preserveBlockSize")
    private Boolean preserveBlockSize = null;
    @SerializedName(value="preservePermissions")
    private Boolean preservePermissions = null;
    @SerializedName(value="logPath")
    private String logPath = null;
    @SerializedName(value="skipChecksumChecks")
    private Boolean skipChecksumChecks = null;
    @SerializedName(value="skipListingChecksumChecks")
    private Boolean skipListingChecksumChecks = null;
    @SerializedName(value="skipTrash")
    private Boolean skipTrash = null;
    @SerializedName(value="replicationStrategy")
    private ReplicationStrategy replicationStrategy = null;
    @SerializedName(value="preserveXAttrs")
    private Boolean preserveXAttrs = null;
    @SerializedName(value="exclusionFilters")
    private List<String> exclusionFilters = null;
    @SerializedName(value="raiseSnapshotDiffFailures")
    private Boolean raiseSnapshotDiffFailures = null;
    @SerializedName(value="deleteLatestSourceSnapshotOnJobFailure")
    private Boolean deleteLatestSourceSnapshotOnJobFailure = null;
    @SerializedName(value="numFetchThreads")
    private BigDecimal numFetchThreads = null;
    @SerializedName(value="destinationCloudAccount")
    private String destinationCloudAccount = null;

    public ApiHdfsReplicationArguments sourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
        return this;
    }

    @Schema(description="")
    public ApiServiceRef getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
    }

    public ApiHdfsReplicationArguments sourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
        return this;
    }

    @Schema(description="The path to replicate.")
    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public ApiHdfsReplicationArguments destinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
        return this;
    }

    @Schema(description="The destination to replicate to.")
    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public ApiHdfsReplicationArguments mapreduceServiceName(String mapreduceServiceName) {
        this.mapreduceServiceName = mapreduceServiceName;
        return this;
    }

    @Schema(description="The mapreduce service to use for the replication job.")
    public String getMapreduceServiceName() {
        return this.mapreduceServiceName;
    }

    public void setMapreduceServiceName(String mapreduceServiceName) {
        this.mapreduceServiceName = mapreduceServiceName;
    }

    public ApiHdfsReplicationArguments schedulerPoolName(String schedulerPoolName) {
        this.schedulerPoolName = schedulerPoolName;
        return this;
    }

    @Schema(description="Name of the scheduler pool to use when submitting the MapReduce job. Currently supports the capacity and fair schedulers. The option is ignored if a different scheduler is configured.")
    public String getSchedulerPoolName() {
        return this.schedulerPoolName;
    }

    public void setSchedulerPoolName(String schedulerPoolName) {
        this.schedulerPoolName = schedulerPoolName;
    }

    public ApiHdfsReplicationArguments userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(description="The user which will execute the MapReduce job. Required if running with Kerberos enabled.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ApiHdfsReplicationArguments sourceUser(String sourceUser) {
        this.sourceUser = sourceUser;
        return this;
    }

    @Schema(description="The user which will perform operations on source cluster. Required if running with Kerberos enabled.")
    public String getSourceUser() {
        return this.sourceUser;
    }

    public void setSourceUser(String sourceUser) {
        this.sourceUser = sourceUser;
    }

    public ApiHdfsReplicationArguments numMaps(BigDecimal numMaps) {
        this.numMaps = numMaps;
        return this;
    }

    @Schema(description="The number of mappers to use for the mapreduce replication job.")
    public BigDecimal getNumMaps() {
        return this.numMaps;
    }

    public void setNumMaps(BigDecimal numMaps) {
        this.numMaps = numMaps;
    }

    public ApiHdfsReplicationArguments dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @Schema(description="Whether to perform a dry run. Defaults to false.")
    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiHdfsReplicationArguments bandwidthPerMap(BigDecimal bandwidthPerMap) {
        this.bandwidthPerMap = bandwidthPerMap;
        return this;
    }

    @Schema(description="The maximum bandwidth (in MB) per mapper in the mapreduce replication job.")
    public BigDecimal getBandwidthPerMap() {
        return this.bandwidthPerMap;
    }

    public void setBandwidthPerMap(BigDecimal bandwidthPerMap) {
        this.bandwidthPerMap = bandwidthPerMap;
    }

    public ApiHdfsReplicationArguments abortOnError(Boolean abortOnError) {
        this.abortOnError = abortOnError;
        return this;
    }

    @Schema(description="Whether to abort on a replication failure. Defaults to false.")
    public Boolean isAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(Boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    public ApiHdfsReplicationArguments removeMissingFiles(Boolean removeMissingFiles) {
        this.removeMissingFiles = removeMissingFiles;
        return this;
    }

    @Schema(description="Whether to delete destination files that are missing in source. Defaults to false.")
    public Boolean isRemoveMissingFiles() {
        return this.removeMissingFiles;
    }

    public void setRemoveMissingFiles(Boolean removeMissingFiles) {
        this.removeMissingFiles = removeMissingFiles;
    }

    public ApiHdfsReplicationArguments preserveReplicationCount(Boolean preserveReplicationCount) {
        this.preserveReplicationCount = preserveReplicationCount;
        return this;
    }

    @Schema(description="Whether to preserve the HDFS replication count. Defaults to false.")
    public Boolean isPreserveReplicationCount() {
        return this.preserveReplicationCount;
    }

    public void setPreserveReplicationCount(Boolean preserveReplicationCount) {
        this.preserveReplicationCount = preserveReplicationCount;
    }

    public ApiHdfsReplicationArguments preserveBlockSize(Boolean preserveBlockSize) {
        this.preserveBlockSize = preserveBlockSize;
        return this;
    }

    @Schema(description="Whether to preserve the HDFS block size. Defaults to false.")
    public Boolean isPreserveBlockSize() {
        return this.preserveBlockSize;
    }

    public void setPreserveBlockSize(Boolean preserveBlockSize) {
        this.preserveBlockSize = preserveBlockSize;
    }

    public ApiHdfsReplicationArguments preservePermissions(Boolean preservePermissions) {
        this.preservePermissions = preservePermissions;
        return this;
    }

    @Schema(description="Whether to preserve the HDFS owner, group and permissions. Defaults to false. Starting from V10, it also preserves ACLs. Defaults to null (no preserve). ACLs is preserved if both clusters enable ACL support, and replication ignores any ACL related failures.")
    public Boolean isPreservePermissions() {
        return this.preservePermissions;
    }

    public void setPreservePermissions(Boolean preservePermissions) {
        this.preservePermissions = preservePermissions;
    }

    public ApiHdfsReplicationArguments logPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    @Schema(description="The HDFS path where the replication log files should be written to.")
    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public ApiHdfsReplicationArguments skipChecksumChecks(Boolean skipChecksumChecks) {
        this.skipChecksumChecks = skipChecksumChecks;
        return this;
    }

    @Schema(description="Whether to skip checksum based file validation during replication. Defaults to false.")
    public Boolean isSkipChecksumChecks() {
        return this.skipChecksumChecks;
    }

    public void setSkipChecksumChecks(Boolean skipChecksumChecks) {
        this.skipChecksumChecks = skipChecksumChecks;
    }

    public ApiHdfsReplicationArguments skipListingChecksumChecks(Boolean skipListingChecksumChecks) {
        this.skipListingChecksumChecks = skipListingChecksumChecks;
        return this;
    }

    @Schema(description="Whether to skip checksum based file comparison during replication. Defaults to false.")
    public Boolean isSkipListingChecksumChecks() {
        return this.skipListingChecksumChecks;
    }

    public void setSkipListingChecksumChecks(Boolean skipListingChecksumChecks) {
        this.skipListingChecksumChecks = skipListingChecksumChecks;
    }

    public ApiHdfsReplicationArguments skipTrash(Boolean skipTrash) {
        this.skipTrash = skipTrash;
        return this;
    }

    @Schema(description="Whether to permanently delete destination files that are missing in source. Defaults to null.")
    public Boolean isSkipTrash() {
        return this.skipTrash;
    }

    public void setSkipTrash(Boolean skipTrash) {
        this.skipTrash = skipTrash;
    }

    public ApiHdfsReplicationArguments replicationStrategy(ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
        return this;
    }

    @Schema(description="")
    public ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public void setReplicationStrategy(ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
    }

    public ApiHdfsReplicationArguments preserveXAttrs(Boolean preserveXAttrs) {
        this.preserveXAttrs = preserveXAttrs;
        return this;
    }

    @Schema(description="Whether to preserve XAttrs, default to false This is introduced in V10. To preserve XAttrs, both CDH versions should be >= 5.2. Replication fails if either cluster does not support XAttrs.")
    public Boolean isPreserveXAttrs() {
        return this.preserveXAttrs;
    }

    public void setPreserveXAttrs(Boolean preserveXAttrs) {
        this.preserveXAttrs = preserveXAttrs;
    }

    public ApiHdfsReplicationArguments exclusionFilters(List<String> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        return this;
    }

    public ApiHdfsReplicationArguments addExclusionFiltersItem(String exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<String>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        return this;
    }

    @Schema(description="Specify regular expression strings to match full paths of files and directories matching source paths and exclude them from the replication. Optional. Available since V11.")
    public List<String> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<String> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public ApiHdfsReplicationArguments raiseSnapshotDiffFailures(Boolean raiseSnapshotDiffFailures) {
        this.raiseSnapshotDiffFailures = raiseSnapshotDiffFailures;
        return this;
    }

    @Schema(description="Flag indicating if failures during snapshotDiff should be ignored or not. When it is set to false then, replication will fallback to full copy listing in case of any error in snapshot diff handling and it will ignore snapshot delete/rename failures at the end of a replication. The flag is by default set to false in distcp tool which means it will ignore snapshot diff failures and mark replication as success for snapshot delete/rename failures. In UI, the flag is set to true by default when source CM Version is greater than 5.14.")
    public Boolean isRaiseSnapshotDiffFailures() {
        return this.raiseSnapshotDiffFailures;
    }

    public void setRaiseSnapshotDiffFailures(Boolean raiseSnapshotDiffFailures) {
        this.raiseSnapshotDiffFailures = raiseSnapshotDiffFailures;
    }

    public ApiHdfsReplicationArguments deleteLatestSourceSnapshotOnJobFailure(Boolean deleteLatestSourceSnapshotOnJobFailure) {
        this.deleteLatestSourceSnapshotOnJobFailure = deleteLatestSourceSnapshotOnJobFailure;
        return this;
    }

    @Schema(description="A flag configuring distcp behaviour for the case when the distcp mapreduce job fails. This failure is sometimes due to some issues with the snapshot. By default, in case of mapreduce job failure the latest source side snapshot is deleted. Set this flag to false to make this replication not delete the last successfully replicated old snapshot of the source dataset in case of job failure. The default value of this flag is true. Not setting this flag is equivalent to the value true.")
    public Boolean isDeleteLatestSourceSnapshotOnJobFailure() {
        return this.deleteLatestSourceSnapshotOnJobFailure;
    }

    public void setDeleteLatestSourceSnapshotOnJobFailure(Boolean deleteLatestSourceSnapshotOnJobFailure) {
        this.deleteLatestSourceSnapshotOnJobFailure = deleteLatestSourceSnapshotOnJobFailure;
    }

    public ApiHdfsReplicationArguments numFetchThreads(BigDecimal numFetchThreads) {
        this.numFetchThreads = numFetchThreads;
        return this;
    }

    @Schema(description="The number of threads to use for fetching the file statuses from HDFS during source file listing. The value 0 means don't use parallel fetching. The null value means to use distcp defaults.")
    public BigDecimal getNumFetchThreads() {
        return this.numFetchThreads;
    }

    public void setNumFetchThreads(BigDecimal numFetchThreads) {
        this.numFetchThreads = numFetchThreads;
    }

    public ApiHdfsReplicationArguments destinationCloudAccount(String destinationCloudAccount) {
        this.destinationCloudAccount = destinationCloudAccount;
        return this;
    }

    @Schema(description="The cloud account name which is used in direct hive cloud replication, if specified.")
    public String getDestinationCloudAccount() {
        return this.destinationCloudAccount;
    }

    public void setDestinationCloudAccount(String destinationCloudAccount) {
        this.destinationCloudAccount = destinationCloudAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsReplicationArguments apiHdfsReplicationArguments = (ApiHdfsReplicationArguments)o;
        return Objects.equals(this.sourceService, apiHdfsReplicationArguments.sourceService) && Objects.equals(this.sourcePath, apiHdfsReplicationArguments.sourcePath) && Objects.equals(this.destinationPath, apiHdfsReplicationArguments.destinationPath) && Objects.equals(this.mapreduceServiceName, apiHdfsReplicationArguments.mapreduceServiceName) && Objects.equals(this.schedulerPoolName, apiHdfsReplicationArguments.schedulerPoolName) && Objects.equals(this.userName, apiHdfsReplicationArguments.userName) && Objects.equals(this.sourceUser, apiHdfsReplicationArguments.sourceUser) && Objects.equals(this.numMaps, apiHdfsReplicationArguments.numMaps) && Objects.equals(this.dryRun, apiHdfsReplicationArguments.dryRun) && Objects.equals(this.bandwidthPerMap, apiHdfsReplicationArguments.bandwidthPerMap) && Objects.equals(this.abortOnError, apiHdfsReplicationArguments.abortOnError) && Objects.equals(this.removeMissingFiles, apiHdfsReplicationArguments.removeMissingFiles) && Objects.equals(this.preserveReplicationCount, apiHdfsReplicationArguments.preserveReplicationCount) && Objects.equals(this.preserveBlockSize, apiHdfsReplicationArguments.preserveBlockSize) && Objects.equals(this.preservePermissions, apiHdfsReplicationArguments.preservePermissions) && Objects.equals(this.logPath, apiHdfsReplicationArguments.logPath) && Objects.equals(this.skipChecksumChecks, apiHdfsReplicationArguments.skipChecksumChecks) && Objects.equals(this.skipListingChecksumChecks, apiHdfsReplicationArguments.skipListingChecksumChecks) && Objects.equals(this.skipTrash, apiHdfsReplicationArguments.skipTrash) && Objects.equals((Object)this.replicationStrategy, (Object)apiHdfsReplicationArguments.replicationStrategy) && Objects.equals(this.preserveXAttrs, apiHdfsReplicationArguments.preserveXAttrs) && Objects.equals(this.exclusionFilters, apiHdfsReplicationArguments.exclusionFilters) && Objects.equals(this.raiseSnapshotDiffFailures, apiHdfsReplicationArguments.raiseSnapshotDiffFailures) && Objects.equals(this.deleteLatestSourceSnapshotOnJobFailure, apiHdfsReplicationArguments.deleteLatestSourceSnapshotOnJobFailure) && Objects.equals(this.numFetchThreads, apiHdfsReplicationArguments.numFetchThreads) && Objects.equals(this.destinationCloudAccount, apiHdfsReplicationArguments.destinationCloudAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceService, this.sourcePath, this.destinationPath, this.mapreduceServiceName, this.schedulerPoolName, this.userName, this.sourceUser, this.numMaps, this.dryRun, this.bandwidthPerMap, this.abortOnError, this.removeMissingFiles, this.preserveReplicationCount, this.preserveBlockSize, this.preservePermissions, this.logPath, this.skipChecksumChecks, this.skipListingChecksumChecks, this.skipTrash, this.replicationStrategy, this.preserveXAttrs, this.exclusionFilters, this.raiseSnapshotDiffFailures, this.deleteLatestSourceSnapshotOnJobFailure, this.numFetchThreads, this.destinationCloudAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsReplicationArguments {\n");
        sb.append("    sourceService: ").append(this.toIndentedString(this.sourceService)).append("\n");
        sb.append("    sourcePath: ").append(this.toIndentedString(this.sourcePath)).append("\n");
        sb.append("    destinationPath: ").append(this.toIndentedString(this.destinationPath)).append("\n");
        sb.append("    mapreduceServiceName: ").append(this.toIndentedString(this.mapreduceServiceName)).append("\n");
        sb.append("    schedulerPoolName: ").append(this.toIndentedString(this.schedulerPoolName)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    sourceUser: ").append(this.toIndentedString(this.sourceUser)).append("\n");
        sb.append("    numMaps: ").append(this.toIndentedString(this.numMaps)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    bandwidthPerMap: ").append(this.toIndentedString(this.bandwidthPerMap)).append("\n");
        sb.append("    abortOnError: ").append(this.toIndentedString(this.abortOnError)).append("\n");
        sb.append("    removeMissingFiles: ").append(this.toIndentedString(this.removeMissingFiles)).append("\n");
        sb.append("    preserveReplicationCount: ").append(this.toIndentedString(this.preserveReplicationCount)).append("\n");
        sb.append("    preserveBlockSize: ").append(this.toIndentedString(this.preserveBlockSize)).append("\n");
        sb.append("    preservePermissions: ").append(this.toIndentedString(this.preservePermissions)).append("\n");
        sb.append("    logPath: ").append(this.toIndentedString(this.logPath)).append("\n");
        sb.append("    skipChecksumChecks: ").append(this.toIndentedString(this.skipChecksumChecks)).append("\n");
        sb.append("    skipListingChecksumChecks: ").append(this.toIndentedString(this.skipListingChecksumChecks)).append("\n");
        sb.append("    skipTrash: ").append(this.toIndentedString(this.skipTrash)).append("\n");
        sb.append("    replicationStrategy: ").append(this.toIndentedString((Object)this.replicationStrategy)).append("\n");
        sb.append("    preserveXAttrs: ").append(this.toIndentedString(this.preserveXAttrs)).append("\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    raiseSnapshotDiffFailures: ").append(this.toIndentedString(this.raiseSnapshotDiffFailures)).append("\n");
        sb.append("    deleteLatestSourceSnapshotOnJobFailure: ").append(this.toIndentedString(this.deleteLatestSourceSnapshotOnJobFailure)).append("\n");
        sb.append("    numFetchThreads: ").append(this.toIndentedString(this.numFetchThreads)).append("\n");
        sb.append("    destinationCloudAccount: ").append(this.toIndentedString(this.destinationCloudAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

