/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.future;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.future.ResponseFuture;

public abstract class MultipleResponseFuture<R extends Response>
implements ResponseFuture<R> {
    protected BlockingQueue<R> queue = new LinkedBlockingQueue<R>();
    protected boolean cancelled = false;
    protected Throwable cause;
    protected int messageId;
    protected LdapConnection connection;

    public MultipleResponseFuture(LdapConnection connection, int messageId) {
        this.messageId = messageId;
        this.connection = connection;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.cancelled) {
            this.cancelled = true;
            if (!this.connection.isRequestCompleted(this.messageId)) {
                this.connection.abandon(this.messageId);
            }
            this.queue.clear();
        }
        return this.cancelled;
    }

    @Override
    public R get() throws InterruptedException {
        return (R)((Response)this.queue.take());
    }

    @Override
    public void set(R response) throws InterruptedException {
        this.queue.add(response);
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException {
        return (R)((Response)this.queue.poll(timeout, unit));
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04106_OPERATION_NOT_SUPPORTED, (Object[])new Object[0]));
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[msgId : ").append(this.messageId).append(", ");
        sb.append("size : ").append(this.queue.size()).append(", ");
        sb.append("Canceled :").append(this.cancelled).append("]");
        return sb.toString();
    }
}

