/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.auth;

import java.io.File;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.auth.JAASClientConfig;

public class AuthUtils {
    static final String JGSS_LOGIN_MODULE = "com.sun.security.jgss.initiate";
    private static ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private static Configuration kerberosConfig;

    public static String getKerberosLoginConfigLocation() {
        return System.getProperty("java.security.auth.login.config");
    }

    public static synchronized Configuration getKerberosJAASConfiguration() throws Exception {
        String configLocation;
        if (kerberosConfig == null && (configLocation = AuthUtils.getKerberosLoginConfigLocation()) != null && !configLocation.isEmpty()) {
            kerberosConfig = AuthUtils.createKerberosJAASConfiguration(configLocation);
        }
        return kerberosConfig;
    }

    public static Configuration createKerberosJAASConfiguration(String kerberosLoginConfig) throws Exception {
        if (kerberosLoginConfig == null) {
            throw new IllegalArgumentException("Invalid login configuration.");
        }
        return new JAASClientConfig(new File(kerberosLoginConfig).toURI().toURL());
    }

    public static Subject getKerberosSubject() {
        Subject subject = null;
        try {
            Configuration jaasConf = AuthUtils.getKerberosJAASConfiguration();
            if (jaasConf != null) {
                log.attemptingKerberosLogin(AuthUtils.getKerberosLoginConfigLocation());
                LoginContext lc = new LoginContext(JGSS_LOGIN_MODULE, null, null, jaasConf);
                lc.login();
                subject = lc.getSubject();
            }
        }
        catch (Exception e) {
            log.failedKerberosLogin(AuthUtils.getKerberosLoginConfigLocation(), JGSS_LOGIN_MODULE, e);
        }
        return subject;
    }
}

