/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.InternalDriver;

public class AutoloadedDriver
implements Driver {
    private static boolean _engineForcedDown = false;
    private static AutoloadedDriver _autoloadedDriver;
    private static Driver _driverModule;

    protected static void registerMe(AutoloadedDriver autoloadedDriver) {
        try {
            _autoloadedDriver = autoloadedDriver;
            DriverManager.registerDriver(_autoloadedDriver);
        }
        catch (SQLException sQLException) {
            String string = MessageService.getTextMessage("I026", sQLException.getMessage());
            throw new IllegalStateException(string);
        }
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return !_engineForcedDown && InternalDriver.embeddedDriverAcceptsURL(string);
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (!InternalDriver.embeddedDriverAcceptsURL(string)) {
            return null;
        }
        return AutoloadedDriver.getDriverModule().connect(string, properties);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return AutoloadedDriver.getDriverModule().getPropertyInfo(string, properties);
    }

    @Override
    public int getMajorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return AutoloadedDriver.getDriverModule().jdbcCompliant();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)Util.notImplemented("getParentLogger()");
    }

    static Driver getDriverModule() throws SQLException {
        if (_engineForcedDown && _autoloadedDriver == null) {
            throw Util.generateCsSQLException("08006.C.8", new Object[0]);
        }
        if (!AutoloadedDriver.isBooted()) {
            EmbeddedDriver.boot();
        }
        return _driverModule;
    }

    static void registerDriverModule(Driver driver) {
        _driverModule = driver;
        _engineForcedDown = false;
        try {
            if (_autoloadedDriver == null) {
                _autoloadedDriver = AutoloadedDriver.makeAutoloadedDriver();
                DriverManager.registerDriver(_autoloadedDriver);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void unregisterDriverModule() {
        _engineForcedDown = true;
        try {
            if (InternalDriver.getDeregister() && _autoloadedDriver != null) {
                AutoloadedDriver.deregisterDriver(_autoloadedDriver);
                _autoloadedDriver = null;
            }
            InternalDriver.setDeregister(true);
            _driverModule = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void deregisterDriver(final AutoloadedDriver autoloadedDriver) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws SQLException {
                    DriverManager.deregisterDriver(autoloadedDriver);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getCause();
        }
        catch (AccessControlException accessControlException) {
            Monitor.logTextMessage("J137", new Object[0]);
            Monitor.logThrowable(accessControlException);
        }
    }

    private static boolean isBooted() {
        return _driverModule != null;
    }

    private static AutoloadedDriver makeAutoloadedDriver() {
        return new AutoloadedDriver();
    }

    static {
        AutoloadedDriver.registerMe(new AutoloadedDriver());
    }
}

