/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.Optional;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;

public class ContentNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 19048239082L;
    private final transient ContentClaim claim;
    private final transient FlowFileRecord flowFile;

    public ContentNotFoundException(ContentClaim claim) {
        super("Could not find content for " + String.valueOf(claim));
        this.claim = claim;
        this.flowFile = null;
    }

    public ContentNotFoundException(ContentClaim claim, Throwable t) {
        super("Could not find content for " + String.valueOf(claim), t);
        this.claim = claim;
        this.flowFile = null;
    }

    public ContentNotFoundException(ContentClaim claim, String message) {
        super("Could not find content for " + String.valueOf(claim) + ": " + message);
        this.claim = claim;
        this.flowFile = null;
    }

    public ContentNotFoundException(FlowFileRecord flowFile, ContentClaim claim, String message) {
        super("Could not find content for " + String.valueOf(claim) + ": " + message);
        this.claim = claim;
        this.flowFile = flowFile;
    }

    public ContentClaim getMissingClaim() {
        return this.claim;
    }

    public Optional<FlowFileRecord> getFlowFile() {
        return Optional.ofNullable(this.flowFile);
    }
}

