/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class TlsPlatform {
    private static final Pattern PROTOCOL_VERSION = Pattern.compile("TLSv(\\d+\\.?\\d*)");
    private static final int FIRST_GROUP = 1;
    private static final List<String> LEGACY_PROTOCOLS = Arrays.asList("TLSv1", "TLSv1.1");
    private static final SortedMap<Float, String> SORTED_PROTOCOLS = TlsPlatform.getDefaultSslContextProtocols();
    private static final Set<String> SUPPORTED_PROTOCOLS = Collections.unmodifiableSet(new TreeSet<String>(SORTED_PROTOCOLS.values()).descendingSet());
    private static final Set<String> PREFERRED_PROTOCOLS = Collections.unmodifiableSet(SUPPORTED_PROTOCOLS.stream().filter(protocol -> !LEGACY_PROTOCOLS.contains(protocol)).collect(Collectors.toSet()));

    public static Set<String> getSupportedProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public static Set<String> getPreferredProtocols() {
        return PREFERRED_PROTOCOLS;
    }

    public static String getLatestProtocol() {
        return (String)SORTED_PROTOCOLS.get(SORTED_PROTOCOLS.lastKey());
    }

    private static SortedMap<Float, String> getDefaultSslContextProtocols() {
        SSLContext defaultContext = TlsPlatform.getDefaultSslContext();
        SSLParameters sslParameters = defaultContext.getSupportedSSLParameters();
        String[] protocols = sslParameters.getProtocols();
        TreeMap<Float, String> sslContextProtocols = new TreeMap<Float, String>();
        for (String protocol : protocols) {
            Matcher protocolVersionMatcher = PROTOCOL_VERSION.matcher(protocol);
            if (!protocolVersionMatcher.matches()) continue;
            String protocolVersion = protocolVersionMatcher.group(1);
            float version = Float.parseFloat(protocolVersion);
            sslContextProtocols.put(Float.valueOf(version), protocol);
        }
        return sslContextProtocols;
    }

    private static SSLContext getDefaultSslContext() {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SSLContext.getDefault() Failed", e);
        }
    }
}

