/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Component } from '@angular/core';
import { Store } from '@ngrx/store';
import {
    selectBreadcrumbs,
    selectNavigationCollapsed,
    selectOperationCollapsed
} from '../../../state/flow/flow.selectors';
import { NavigationControl } from './navigation-control/navigation-control.component';
import { OperationControl } from './operation-control/operation-control.component';
import { AsyncPipe } from '@angular/common';
import { NiFiState } from '../../../../../state';

@Component({
    selector: 'graph-controls',
    templateUrl: './graph-controls.component.html',
    imports: [NavigationControl, OperationControl, AsyncPipe],
    styleUrls: ['./graph-controls.component.scss']
})
export class GraphControls {
    navigationCollapsed$ = this.store.select(selectNavigationCollapsed);
    operationCollapsed$ = this.store.select(selectOperationCollapsed);
    breadcrumbEntity$ = this.store.select(selectBreadcrumbs);

    constructor(private store: Store<NiFiState>) {}
}
