/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.InventoryConfigurationState;
import software.amazon.awssdk.services.s3.model.MetadataTableEncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryTableConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryTableConfiguration> {
    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationState").getter(InventoryTableConfiguration.getter(InventoryTableConfiguration::configurationStateAsString)).setter(InventoryTableConfiguration.setter(Builder::configurationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState").unmarshallLocationName("ConfigurationState").build(), RequiredTrait.create()}).build();
    private static final SdkField<MetadataTableEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(InventoryTableConfiguration.getter(InventoryTableConfiguration::encryptionConfiguration)).setter(InventoryTableConfiguration.setter(Builder::encryptionConfiguration)).constructor(MetadataTableEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").unmarshallLocationName("EncryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_STATE_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InventoryTableConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configurationState;
    private final MetadataTableEncryptionConfiguration encryptionConfiguration;

    private InventoryTableConfiguration(BuilderImpl builder) {
        this.configurationState = builder.configurationState;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final InventoryConfigurationState configurationState() {
        return InventoryConfigurationState.fromValue(this.configurationState);
    }

    public final String configurationStateAsString() {
        return this.configurationState;
    }

    public final MetadataTableEncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryTableConfiguration)) {
            return false;
        }
        InventoryTableConfiguration other = (InventoryTableConfiguration)obj;
        return Objects.equals(this.configurationStateAsString(), other.configurationStateAsString()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"InventoryTableConfiguration").add("ConfigurationState", (Object)this.configurationStateAsString()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationState": {
                return Optional.ofNullable(clazz.cast(this.configurationStateAsString()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InventoryTableConfiguration, T> g) {
        return obj -> g.apply((InventoryTableConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationState;
        private MetadataTableEncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryTableConfiguration model) {
            this.configurationState(model.configurationState);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getConfigurationState() {
            return this.configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(InventoryConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        public final MetadataTableEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(MetadataTableEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(MetadataTableEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public InventoryTableConfiguration build() {
            return new InventoryTableConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryTableConfiguration> {
        public Builder configurationState(String var1);

        public Builder configurationState(InventoryConfigurationState var1);

        public Builder encryptionConfiguration(MetadataTableEncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<MetadataTableEncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((MetadataTableEncryptionConfiguration)((MetadataTableEncryptionConfiguration.Builder)MetadataTableEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }
    }
}

