/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.ott;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.ott.OneTimeTokenGenerationSuccessHandler;
import org.springframework.util.Assert;

public final class RedirectOneTimeTokenGenerationSuccessHandler
implements OneTimeTokenGenerationSuccessHandler {
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private final String redirectUrl;

    public RedirectOneTimeTokenGenerationSuccessHandler(String redirectUrl) {
        Assert.hasText((String)redirectUrl, (String)"redirectUrl cannot be empty or null");
        this.redirectUrl = redirectUrl;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, OneTimeToken oneTimeToken) throws IOException {
        this.redirectStrategy.sendRedirect(request, response, this.redirectUrl);
    }
}

