/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.VersionedFlowSnapshotMetadataSetResult;
import org.apache.nifi.toolkit.client.FlowClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.VersionsClient;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;

public class PGGetAllVersions
extends AbstractNiFiCommand<VersionedFlowSnapshotMetadataSetResult> {
    public PGGetAllVersions() {
        super("pg-get-all-versions", VersionedFlowSnapshotMetadataSetResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns all of the available versions for a version controlled process group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VersionedFlowSnapshotMetadataSetResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        VersionsClient versionsClient = client.getVersionsClient();
        VersionControlInformationEntity existingVersionControlInfo = versionsClient.getVersionControlInfo(pgId);
        VersionControlInformationDTO existingVersionControlDTO = existingVersionControlInfo.getVersionControlInformation();
        if (existingVersionControlDTO == null) {
            throw new NiFiClientException("Process group is not under version control");
        }
        String registryId = existingVersionControlDTO.getRegistryId();
        String bucketId = existingVersionControlDTO.getBucketId();
        String flowId = existingVersionControlDTO.getFlowId();
        FlowClient flowClient = client.getFlowClient();
        VersionedFlowSnapshotMetadataSetEntity versions = flowClient.getVersions(registryId, bucketId, flowId);
        if (versions.getVersionedFlowSnapshotMetadataSet() == null || versions.getVersionedFlowSnapshotMetadataSet().isEmpty()) {
            throw new NiFiClientException("No versions available");
        }
        return new VersionedFlowSnapshotMetadataSetResult(this.getResultType(properties), versions);
    }
}

