/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.PGRename;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.FlowClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ProcessGroupBox;
import org.apache.nifi.toolkit.client.ProcessGroupClient;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;

public class PGImport
extends AbstractNiFiCommand<StringResult> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public PGImport() {
        super("pg-import", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a new process group by importing a versioned flow from a registry or using a local file. If no process group ID is specified, then the created process group will be placed in the root group. If using import from a registry and no version is specified, then the latest will be used. If only one registry client exists in NiFi, then it does not need to be specified and will be automatically selected. The x and y coordinates for the position of the imported process group may be optionally specified. If left blank, the position will automatically be selected to avoid overlapping with existing process groups. If a process group name is specified, the imported process group will be renamed with the specified name.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.PG_NAME.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_ID.createOption());
        this.addOption(CommandOption.BUCKET_ID.createOption());
        this.addOption(CommandOption.FLOW_ID.createOption());
        this.addOption(CommandOption.FLOW_VERSION.createOption());
        this.addOption(CommandOption.FLOW_BRANCH.createOption());
        this.addOption(CommandOption.POS_X.createOption());
        this.addOption(CommandOption.POS_Y.createOption());
        this.addOption(CommandOption.KEEP_EXISTING_PARAMETER_CONTEXT.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String parentPgId;
        File input;
        String inputSource = this.getArg(properties, CommandOption.INPUT_SOURCE);
        boolean isInputSpecified = StringUtils.isNotBlank((CharSequence)inputSource);
        String bucketId = this.getArg(properties, CommandOption.BUCKET_ID);
        String flowId = this.getArg(properties, CommandOption.FLOW_ID);
        String flowVersion = this.getArg(properties, CommandOption.FLOW_VERSION);
        String flowBranch = this.getArg(properties, CommandOption.FLOW_BRANCH);
        String posXStr = this.getArg(properties, CommandOption.POS_X);
        String posYStr = this.getArg(properties, CommandOption.POS_Y);
        String keepExistingPC = this.getArg(properties, CommandOption.KEEP_EXISTING_PARAMETER_CONTEXT);
        boolean posXExists = StringUtils.isNotBlank((CharSequence)posXStr);
        boolean posYExists = StringUtils.isNotBlank((CharSequence)posYStr);
        File file = input = isInputSpecified ? new File(inputSource) : null;
        if (!isInputSpecified) {
            if (StringUtils.isBlank((CharSequence)bucketId)) {
                throw new IllegalArgumentException("Input path is not specified so Bucket ID must be specified");
            }
            if (StringUtils.isBlank((CharSequence)flowId)) {
                throw new IllegalArgumentException("Input path is not specified so Flow ID must be specified");
            }
        } else {
            if (!(input.exists() && input.isFile() && input.canRead())) {
                throw new IllegalArgumentException("Specified input is not a local readable file: " + inputSource);
            }
            if (StringUtils.isNotBlank((CharSequence)bucketId)) {
                throw new IllegalArgumentException("Input path is specified so Bucket ID should not be specified");
            }
            if (StringUtils.isNotBlank((CharSequence)flowId)) {
                throw new IllegalArgumentException("Input path is specified so Flow ID should not be specified");
            }
            if (StringUtils.isNotBlank((CharSequence)flowVersion)) {
                throw new IllegalArgumentException("Input path is specified so Flow Version should not be specified");
            }
            if (StringUtils.isNotBlank((CharSequence)flowBranch)) {
                throw new IllegalArgumentException("Input path is specified so Flow Branch should not be specified");
            }
        }
        if (posXExists && !posYExists) {
            throw new IllegalArgumentException("Missing Y position - Please specify both X and Y, or specify neither");
        }
        if (posYExists && !posXExists) {
            throw new IllegalArgumentException("Missing X position - Please specify both X and Y, or specify neither");
        }
        if (StringUtils.isNotBlank((CharSequence)keepExistingPC) && !keepExistingPC.equals("true") && !keepExistingPC.equals("false")) {
            throw new IllegalArgumentException("Keep Existing Parameter Context must be either true or false");
        }
        if (StringUtils.isBlank((CharSequence)keepExistingPC)) {
            keepExistingPC = "true";
        }
        if (StringUtils.isBlank((CharSequence)(parentPgId = this.getArg(properties, CommandOption.PG_ID)))) {
            FlowClient flowClient = client.getFlowClient();
            parentPgId = flowClient.getRootGroupId();
        }
        PositionDTO posDto = new PositionDTO();
        if (posXExists && posYExists) {
            posDto.setX(Double.valueOf(Double.parseDouble(posXStr)));
            posDto.setY(Double.valueOf(Double.parseDouble(posYStr)));
        } else {
            ProcessGroupBox pgBox = client.getFlowClient().getSuggestedProcessGroupCoordinates(parentPgId);
            posDto.setX(Double.valueOf(Integer.valueOf(pgBox.getX()).doubleValue()));
            posDto.setY(Double.valueOf(Integer.valueOf(pgBox.getY()).doubleValue()));
        }
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        ProcessGroupEntity createdEntity = null;
        if (!isInputSpecified) {
            String registryId = this.getArg(properties, CommandOption.REGISTRY_CLIENT_ID);
            if (StringUtils.isBlank((CharSequence)registryId)) {
                FlowRegistryClientsEntity registries = client.getControllerClient().getRegistryClients();
                Set entities = registries.getRegistries();
                if (entities == null || entities.isEmpty()) {
                    throw new NiFiClientException("No registry clients available");
                }
                if (entities.size() == 1) {
                    registryId = ((FlowRegistryClientEntity)entities.stream().findFirst().get()).getId();
                } else {
                    throw new MissingOptionException(CommandOption.REGISTRY_CLIENT_ID.getLongName() + " must be provided when there is more than one available");
                }
            }
            if (flowVersion == null) {
                VersionedFlowSnapshotMetadataSetEntity flowVersions = client.getFlowClient().getVersions(registryId, bucketId, flowId, flowBranch);
                flowVersion = Collections.max(flowVersions.getVersionedFlowSnapshotMetadataSet(), Comparator.comparingLong(e -> e.getVersionedFlowSnapshotMetadata().getTimestamp())).getVersionedFlowSnapshotMetadata().getVersion();
            }
            VersionControlInformationDTO versionControlInfo = new VersionControlInformationDTO();
            versionControlInfo.setRegistryId(registryId);
            versionControlInfo.setBucketId(bucketId);
            versionControlInfo.setFlowId(flowId);
            versionControlInfo.setVersion(flowVersion);
            if (StringUtils.isNotBlank((CharSequence)flowBranch)) {
                versionControlInfo.setBranch(flowBranch);
            }
            ProcessGroupDTO pgDto = new ProcessGroupDTO();
            pgDto.setVersionControlInformation(versionControlInfo);
            pgDto.setPosition(posDto);
            ProcessGroupEntity pgEntity = new ProcessGroupEntity();
            pgEntity.setComponent(pgDto);
            pgEntity.setRevision(this.getInitialRevisionDTO());
            createdEntity = pgClient.createProcessGroup(parentPgId, pgEntity, Boolean.parseBoolean(keepExistingPC));
        } else {
            JsonNode rootNode = OBJECT_MAPPER.readTree(input);
            JsonNode flowContentsNode = rootNode.path("flowContents");
            String pgName = flowContentsNode.path("name").asText();
            createdEntity = pgClient.upload(parentPgId, input, pgName, posDto.getX(), posDto.getY());
        }
        String pgName = this.getArg(properties, CommandOption.PG_NAME);
        if (StringUtils.isNotBlank((CharSequence)pgName)) {
            PGRename pgRename = new PGRename();
            pgRename.rename(pgName, pgClient, createdEntity);
        }
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }
}

