/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.streampane.tooltip;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.debugger.streampane.tooltip.ToolTip;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;

final class FontToolTip
implements ToolTip {
    private static final Log LOG = LogFactory.getLog(FontToolTip.class);
    private String markup;

    FontToolTip(PDResources resources, String rowText) {
        this.initUI(this.extractFontReference(rowText), resources);
    }

    private void initUI(String fontReferenceName, PDResources resources) {
        PDFont font = null;
        for (COSName name : resources.getFontNames()) {
            if (!name.getName().equals(fontReferenceName)) continue;
            try {
                font = resources.getFont(name);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (font != null) {
            this.markup = "<html>" + font.getName() + "</html>";
        }
    }

    private String extractFontReference(String rowText) {
        return rowText.trim().split(" ")[0].substring(1);
    }

    @Override
    public String getToolTipText() {
        return this.markup;
    }
}

