/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.internal;

import java.io.PrintWriter;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.internal.CommandHook;
import picocli.CommandLine;

public class CommanderFactory {
    public static CommandLine createRootCommanderWithHook(Object object, CommandLine.IDefaultValueProvider defaultValueProvider) {
        CommandLine commander = new CommandLine(object);
        commander.setExecutionStrategy((CommandLine.IExecutionStrategy)new CommandExecutionStrategy());
        commander.setExecutionExceptionHandler((ex, commandLine, parseResult) -> {
            PrintWriter errPrinter = commandLine.getErr();
            if (ex instanceof PulsarAdminException.ConnectException) {
                errPrinter.println(ex.getMessage());
                errPrinter.println();
                errPrinter.println("Error connecting to Pulsar");
                return 1;
            }
            if (ex instanceof PulsarAdminException) {
                errPrinter.println(((PulsarAdminException)((Object)((Object)ex))).getHttpError());
                errPrinter.println();
                errPrinter.println("Reason: " + ex.getMessage());
                return 1;
            }
            throw ex;
        });
        if (defaultValueProvider != null) {
            commander.setDefaultValueProvider(defaultValueProvider);
        }
        return commander;
    }

    static class CommandExecutionStrategy
    implements CommandLine.IExecutionStrategy {
        CommandExecutionStrategy() {
        }

        private int preRun(CommandLine.ParseResult parseResult) {
            int exitCode;
            Object userObject = parseResult.commandSpec().userObject();
            if (userObject instanceof CommandHook && (exitCode = ((CommandHook)userObject).preRun()) != 0) {
                return exitCode;
            }
            if (parseResult.hasSubcommand()) {
                return this.preRun(parseResult.subcommand());
            }
            return 0;
        }

        public int execute(CommandLine.ParseResult parseResult) throws CommandLine.ExecutionException, CommandLine.ParameterException {
            int preRunCode = this.preRun(parseResult);
            if (preRunCode != 0) {
                return preRunCode;
            }
            return new CommandLine.RunLast().execute(parseResult);
        }
    }
}

