/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config.predicates;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.security.access.config.AclRulePredicatesBuilder;
import org.apache.qpid.server.security.access.config.Property;
import org.apache.qpid.server.security.access.config.RulePredicate;
import org.apache.qpid.server.security.access.config.predicates.AnyValue;
import org.apache.qpid.server.security.access.config.predicates.AttributeNames;
import org.apache.qpid.server.security.access.config.predicates.Equal;
import org.apache.qpid.server.security.access.config.predicates.MultiValue;
import org.apache.qpid.server.security.access.config.predicates.WildCard;
import org.apache.qpid.server.security.access.firewall.FirewallRuleFactory;
import org.apache.qpid.server.security.access.util.PrefixTreeSet;

public final class RulePredicateBuilder {
    private final FirewallRuleFactory _factory;

    public RulePredicateBuilder(FirewallRuleFactory factory) {
        this._factory = Objects.requireNonNull(factory);
    }

    public RulePredicateBuilder() {
        this._factory = new FirewallRuleFactory();
    }

    public RulePredicate build(Map<Property, ? extends Collection<?>> properties) {
        RulePredicate predicate = RulePredicate.any();
        for (Map.Entry<Property, Collection<?>> entry : properties.entrySet()) {
            predicate = predicate.and(this.buildPredicate(entry.getKey(), entry.getValue()));
        }
        return predicate;
    }

    private RulePredicate buildPredicate(Property property, Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return RulePredicate.any();
        }
        switch (property) {
            case FROM_HOSTNAME: {
                return this._factory.createForHostname(this.toSet(values));
            }
            case FROM_NETWORK: {
                return this._factory.createForNetwork(this.toSet(values));
            }
            case ATTRIBUTES: {
                return AttributeNames.newInstance(this.toSet(values));
            }
        }
        return this.buildGenericPredicate(property, values);
    }

    private Set<String> toSet(Collection<?> values) {
        return values.stream().map(Object::toString).collect(Collectors.toSet());
    }

    private RulePredicate buildGenericPredicate(Property property, Collection<?> values) {
        if (values instanceof PrefixTreeSet && values.size() > 2) {
            return MultiValue.newInstance(property, ((PrefixTreeSet)values).toPrefixTree());
        }
        RulePredicate predicate = RulePredicate.none();
        for (Object value : values) {
            if (value instanceof String) {
                predicate = predicate.or(this.string(property, (String)value));
                continue;
            }
            predicate = predicate.or(Equal.newInstance(property, value));
        }
        return predicate;
    }

    private RulePredicate string(Property property, String value) {
        if ("*".equals(value)) {
            return AnyValue.newInstance(property);
        }
        if (value.endsWith("*")) {
            return WildCard.newInstance(property, value.substring(0, value.length() - AclRulePredicatesBuilder.WILD_CARD_LENGTH));
        }
        return Equal.newInstance(property, value);
    }
}

