/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQPConnection_0_8Impl;
import org.apache.qpid.server.protocol.v0_8.ServerDecoder;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerDecoder
extends ServerDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerDecoder.class);
    private final AMQPConnection_0_8Impl _connection;

    public BrokerDecoder(AMQPConnection_0_8Impl connection) {
        super(connection);
        this._connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFrame(int channelId, byte type, long bodySize, QpidByteBuffer in) throws AMQFrameDecodingException {
        long startTime = 0L;
        try {
            AMQChannel channel;
            if (LOGGER.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if ((channel = this._connection.getChannel(channelId)) != null) {
                this._connection.channelRequiresSync(channel);
            }
            this.doProcessFrame(channelId, type, bodySize, in);
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Frame handled in {} ms.", (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    @Override
    protected final int processAMQPFrames(QpidByteBuffer buf) throws AMQFrameDecodingException {
        int required = this.decodable(buf);
        if (required == 0) {
            int channelId = buf.getUnsignedShort(buf.position() + 1);
            AMQChannel channel = this._connection.getChannel(channelId);
            if (channel == null) {
                this.processInput(buf);
                return 0;
            }
            try {
                return AccessController.doPrivileged(() -> {
                    int required1;
                    do {
                        this.processInput(buf);
                    } while ((required1 = this.decodable(buf)) == 0 && buf.getUnsignedShort(buf.position() + 1) == channelId);
                    return required1;
                }, channel.getAccessControllerContext());
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof AMQFrameDecodingException) {
                    throw (AMQFrameDecodingException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new ServerScopedRuntimeException(cause);
            }
        }
        return required;
    }

    private void doProcessFrame(int channelId, byte type, long bodySize, QpidByteBuffer in) throws AMQFrameDecodingException {
        super.processFrame(channelId, type, bodySize, in);
    }
}

