/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.networkRestore;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;

public class Protocol
extends BinaryProtocol {
    public static final int VERSION = 2;
    public final BinaryProtocol.MessageOp FEEDER_INFO_REQ = new BinaryProtocol.MessageOp(1, FeederInfoReq.class);
    public final BinaryProtocol.MessageOp FEEDER_INFO_RESP = new BinaryProtocol.MessageOp(2, FeederInfoResp.class);
    public final BinaryProtocol.MessageOp FILE_LIST_REQ = new BinaryProtocol.MessageOp(3, FileListReq.class);
    public final BinaryProtocol.MessageOp FILE_LIST_RESP = new BinaryProtocol.MessageOp(4, FileListResp.class);
    public final BinaryProtocol.MessageOp FILE_REQ = new BinaryProtocol.MessageOp(5, FileReq.class);
    public final BinaryProtocol.MessageOp FILE_START = new BinaryProtocol.MessageOp(6, FileStart.class);
    public final BinaryProtocol.MessageOp FILE_END = new BinaryProtocol.MessageOp(7, FileEnd.class);
    public final BinaryProtocol.MessageOp FILE_INFO_REQ = new BinaryProtocol.MessageOp(8, FileInfoReq.class);
    public final BinaryProtocol.MessageOp FILE_INFO_RESP = new BinaryProtocol.MessageOp(9, FileInfoResp.class);
    public final BinaryProtocol.MessageOp DONE = new BinaryProtocol.MessageOp(10, Done.class);

    public Protocol(NameIdPair nameIdPair, int configuredVersion, EnvironmentImpl envImpl) {
        super(nameIdPair, 2, configuredVersion, envImpl);
        this.initializeMessageOps(new BinaryProtocol.MessageOp[]{this.FEEDER_INFO_REQ, this.FEEDER_INFO_RESP, this.FILE_LIST_REQ, this.FILE_LIST_RESP, this.FILE_INFO_REQ, this.FILE_INFO_RESP, this.FILE_REQ, this.FILE_START, this.FILE_END, this.DONE});
    }

    public class Done
    extends BinaryProtocol.SimpleMessage {
        public Done() {
            super(Protocol.this);
        }

        public Done(ByteBuffer buffer) {
            super(Protocol.this);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.DONE;
        }
    }

    public class FileEnd
    extends FileInfoResp {
        public FileEnd(String fileName, long fileLength, long lastModifiedTime, byte[] digestSHA1) {
            super(fileName, fileLength, lastModifiedTime, digestSHA1);
        }

        public FileEnd(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FILE_END;
        }

        @Override
        public ByteBuffer wireFormat() {
            return super.wireFormat();
        }
    }

    public class FileStart
    extends BinaryProtocol.SimpleMessage {
        protected final String fileName;
        protected final long fileLength;
        protected final long lastModifiedTime;

        public FileStart(String fileName, long fileLength, long lastModifiedTime) {
            super(Protocol.this);
            this.fileName = fileName;
            this.fileLength = fileLength;
            this.lastModifiedTime = lastModifiedTime;
        }

        public FileStart(ByteBuffer buffer) {
            super(Protocol.this);
            this.fileName = Protocol.this.getString(buffer);
            this.fileLength = LogUtils.readLong(buffer);
            this.lastModifiedTime = LogUtils.readLong(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FILE_START;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.fileName, this.fileLength, this.lastModifiedTime);
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }
    }

    public class FileInfoResp
    extends FileStart {
        private final byte[] digestSHA1;

        public FileInfoResp(String fileName, long fileLength, long lastModifiedTime, byte[] digestSHA1) {
            super(fileName, fileLength, lastModifiedTime);
            this.digestSHA1 = digestSHA1;
        }

        public FileInfoResp(ByteBuffer buffer) {
            super(buffer);
            this.digestSHA1 = this.getByteArray(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FILE_INFO_RESP;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.fileName, this.fileLength, this.lastModifiedTime, this.digestSHA1);
        }

        public byte[] getDigestSHA1() {
            return this.digestSHA1;
        }
    }

    public class FileInfoReq
    extends FileReq {
        private final boolean needSHA1;

        public FileInfoReq(String fileName, boolean needSHA1) {
            super(fileName);
            this.needSHA1 = needSHA1;
        }

        public FileInfoReq(ByteBuffer buffer) {
            super(buffer);
            this.needSHA1 = this.getBoolean(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FILE_INFO_REQ;
        }

        @Override
        public ByteBuffer wireFormat() {
            return super.wireFormat(this.fileName, this.needSHA1);
        }

        public boolean getNeedSHA1() {
            return this.needSHA1;
        }
    }

    public class FileReq
    extends BinaryProtocol.SimpleMessage {
        protected final String fileName;

        public FileReq(String fileName) {
            super(Protocol.this);
            this.fileName = fileName;
        }

        public FileReq(ByteBuffer buffer) {
            super(Protocol.this);
            this.fileName = Protocol.this.getString(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FILE_REQ;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.fileName);
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    public class FileListResp
    extends BinaryProtocol.SimpleMessage {
        private final String[] fileNames;

        public FileListResp(String[] fileNames) {
            super(Protocol.this);
            this.fileNames = fileNames;
        }

        public FileListResp(ByteBuffer buffer) {
            super(Protocol.this);
            this.fileNames = this.getStringArray(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FILE_LIST_RESP;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(new Object[]{this.fileNames});
        }

        public String[] getFileNames() {
            return this.fileNames;
        }
    }

    public class FileListReq
    extends BinaryProtocol.SimpleMessage {
        public FileListReq() {
            super(Protocol.this);
        }

        public FileListReq(ByteBuffer buffer) {
            super(Protocol.this);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FILE_LIST_REQ;
        }
    }

    public class FeederInfoResp
    extends BinaryProtocol.SimpleMessage {
        private final int activeFeeders;
        private final VLSN rangeFirst;
        private final VLSN rangeLast;

        public FeederInfoResp(int activeFeeders, VLSN rangeFirst, VLSN rangeLast) {
            super(Protocol.this);
            this.activeFeeders = activeFeeders;
            this.rangeFirst = rangeFirst;
            this.rangeLast = rangeLast;
        }

        public FeederInfoResp(ByteBuffer buffer) {
            super(Protocol.this);
            this.activeFeeders = LogUtils.readInt(buffer);
            this.rangeFirst = this.getVLSN(buffer);
            this.rangeLast = this.getVLSN(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FEEDER_INFO_RESP;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.activeFeeders, this.rangeFirst, this.rangeLast);
        }

        public int getActiveFeeders() {
            return this.activeFeeders;
        }

        public VLSN getRangeFirst() {
            return this.rangeFirst;
        }

        public VLSN getRangeLast() {
            return this.rangeLast;
        }
    }

    public class FeederInfoReq
    extends BinaryProtocol.SimpleMessage {
        public FeederInfoReq() {
            super(Protocol.this);
        }

        public FeederInfoReq(ByteBuffer buffer) {
            super(Protocol.this);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return Protocol.this.FEEDER_INFO_REQ;
        }
    }
}

