/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.log;

import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.storage.io.ProtoBufFile;
import com.alipay.sofa.jraft.util.AsciiStringUtil;
import com.alipay.sofa.jraft.util.Bits;
import com.google.protobuf.Message;
import com.google.protobuf.ZeroByteStringHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class CheckpointFile {
    private final String path;

    public void destroy() {
        FileUtils.deleteQuietly((File)new File(this.path));
    }

    public String getPath() {
        return this.path;
    }

    public CheckpointFile(String path) {
        this.path = path;
    }

    public synchronized boolean save(Checkpoint checkpoint) throws IOException {
        ProtoBufFile file = new ProtoBufFile(this.path);
        byte[] data = checkpoint.encode();
        LocalFileMetaOutter.LocalFileMeta meta = LocalFileMetaOutter.LocalFileMeta.newBuilder().setUserMeta(ZeroByteStringHelper.wrap(data)).build();
        return file.save((Message)meta, true);
    }

    public Checkpoint load() throws IOException {
        byte[] data;
        Checkpoint checkpoint;
        ProtoBufFile file = new ProtoBufFile(this.path);
        LocalFileMetaOutter.LocalFileMeta meta = (LocalFileMetaOutter.LocalFileMeta)file.load();
        if (meta != null && (checkpoint = new Checkpoint(null, -1)).decode(data = meta.getUserMeta().toByteArray())) {
            return checkpoint;
        }
        return null;
    }

    public static final class Checkpoint {
        public String segFilename;
        public int committedPos;

        public Checkpoint(String segFilename, int committedPos) {
            this.segFilename = segFilename;
            this.committedPos = committedPos;
        }

        byte[] encode() {
            byte[] ps = AsciiStringUtil.unsafeEncode(this.segFilename);
            byte[] bs = new byte[8 + ps.length];
            Bits.putInt(bs, 0, this.committedPos);
            Bits.putInt(bs, 4, ps.length);
            System.arraycopy(ps, 0, bs, 8, ps.length);
            return bs;
        }

        boolean decode(byte[] bs) {
            if (bs.length < 8) {
                return false;
            }
            this.committedPos = Bits.getInt(bs, 0);
            int len = Bits.getInt(bs, 4);
            this.segFilename = AsciiStringUtil.unsafeDecode(bs, 8, len);
            return this.committedPos >= 0 && !this.segFilename.isEmpty();
        }

        public String toString() {
            return "Checkpoint [segFilename=" + this.segFilename + ", committedPos=" + this.committedPos + "]";
        }
    }
}

