/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.ssl;

import com.netflix.config.ConcurrentCompositeConfiguration;
import org.apache.servicecomb.foundation.ssl.SSLOption;

public interface SSLOptionFactory {
    public static SSLOptionFactory createSSLOptionFactory(String tag, ConcurrentCompositeConfiguration configSource) {
        String name = SSLOption.getStringProperty(configSource, null, "ssl." + tag + ".sslOptionFactory", "ssl.sslOptionFactory");
        return SSLOptionFactory.createSSLOptionFactory(name);
    }

    public static SSLOptionFactory createSSLOptionFactory(String className) {
        if (className != null && !className.isEmpty()) {
            try {
                return (SSLOptionFactory)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to create SSLOptionFactory.", e);
            }
        }
        return null;
    }

    public SSLOption createSSLOption();
}

