/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.internal.converter;

import io.swagger.models.Model;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.Property;
import java.util.List;
import org.apache.servicecomb.codec.protobuf.internal.converter.BodyParameterAdapter;
import org.apache.servicecomb.codec.protobuf.internal.converter.ModelAdapter;
import org.apache.servicecomb.codec.protobuf.internal.converter.PropertyAdapter;
import org.apache.servicecomb.codec.protobuf.internal.converter.SerializableParameterAdapter;

public interface SwaggerTypeAdapter {
    public static SwaggerTypeAdapter create(Object swaggerType) {
        if (swaggerType instanceof SwaggerTypeAdapter) {
            return (SwaggerTypeAdapter)swaggerType;
        }
        if (swaggerType instanceof Model) {
            return new ModelAdapter((Model)swaggerType);
        }
        if (swaggerType instanceof Property) {
            return new PropertyAdapter((Property)swaggerType);
        }
        if (swaggerType instanceof SerializableParameter) {
            return new SerializableParameterAdapter((SerializableParameter)swaggerType);
        }
        if (swaggerType instanceof BodyParameter) {
            return new BodyParameterAdapter((BodyParameter)swaggerType);
        }
        throw new IllegalStateException("not support swagger type: " + swaggerType.getClass().getName());
    }

    public String getRefType();

    public Property getArrayItem();

    public Property getMapItem();

    public List<String> getEnum();

    public String getType();

    public String getFormat();

    public boolean isJavaLangObject();
}

