/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.Markable;

final class OutputStreamAdapter
extends OutputStream
implements Markable {
    final ChannelDataOutput output;

    OutputStreamAdapter(ChannelDataOutput output) {
        this.output = output;
    }

    @Override
    public void write(int b) throws IOException {
        this.output.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
    }

    @Override
    public void mark() {
        this.output.mark();
    }

    @Override
    public void reset() throws IOException {
        this.output.reset();
    }

    @Override
    public void reset(long mark) throws IOException {
        this.output.reset(mark);
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.output.getStreamPosition();
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        try (WritableByteChannel writableByteChannel = this.output.channel;){
            this.output.flush();
        }
    }
}

